//
//  NSimple_SliderCell.swift
//  NearbyStores
//
//  Created by Amine  on 10/11/19.
//  Copyright © 2019 Amine. All rights reserved.
//

import UIKit
import Kingfisher
import SkeletonView

protocol NSimple_Slider_Delegate {
    func onPressed(object: Banner)
}

class NSimple_SliderCell: UICollectionViewCell {
    
    var delegate: NSimple_Slider_Delegate? = nil

    override func awakeFromNib() {
        super.awakeFromNib()
        // Initialization code
    }
    
    
    @IBOutlet weak var gradientBG: GradientBGView!
    @IBOutlet weak var image: UIImageView!
    @IBOutlet weak var title_label: UILabel!
    @IBOutlet weak var btnDiscount: UIButton!
    @IBOutlet weak var btnDiscountBackground: GradientBGView!
    
    func setting() {
        
        title_label.initBolodFont(size: 23)
       
        let tap = UITapGestureRecognizer(target: self, action: #selector(self.handleTap(_:)))
        self.addGestureRecognizer(tap)
        self.isUserInteractionEnabled = true
        
    }
    
    @objc func handleTap(_ sender: UITapGestureRecognizer? = nil) {
        // handling code
        if let banner = self.banner{
            if let del = delegate{
                del.onPressed(object: banner)
            }
        }
    }
    
    var banner: Banner? = nil
     
    func setup(banner: Banner){
       
        self.banner = banner
        
        setting()

        let paragraphStyle = NSMutableParagraphStyle()
        paragraphStyle.lineHeightMultiple = 0.8
        
        let attrString = NSMutableAttributedString(string: banner.title)

        attrString.addAttribute(.font, value: UIFont(name: AppConfig.Design.Fonts.bold, size: 23), range:NSMakeRange(0, attrString.length))
        attrString.addAttribute(.paragraphStyle, value:paragraphStyle, range:NSMakeRange(0, attrString.length))
        title_label.attributedText = attrString
        
        btnDiscount.tintColor = .white
        btnDiscount.titleLabel?.initBolodFont(size: 11.8)
        btnDiscount.backgroundColor = .clear
        btnDiscount.setTitleColor(.white, for: .normal)
        btnDiscount.titleLabel?.textAlignment = .center
        btnDiscount.setTitle("See more".localized, for: .normal)
        btnDiscountBackground.roundCorners(radius: btnDiscountBackground.frame.size.height / 2)
        btnDiscountBackground.tintColor = Colors.primaryColor
        //set image
        if let image = banner.images {
                       
            let url = URL(string: image.url500_500)
            self.image.kf.indicatorType = .activity
            self.image.kf.setImage(with: url,options: [.transition(.fade(0.2))])
        }else{
                       
            if let img = UIImage(named: "default_store_image") {
                self.image.image = img
            }
        }
        
        
        if(banner.title==""){
            self.gradientBG.isHidden = true
            self.title_label.isHidden = true
            self.btnDiscount.isHidden = true
            self.btnDiscountBackground.isHidden = true
        }else{
            self.gradientBG.isHidden = false
            self.title_label.isHidden = false
            self.btnDiscount.isHidden = false
            self.btnDiscountBackground.isHidden = false
        }

        
    }
    
    
    
      func makeAsDefault() {
        
        self.image.hideSkeleton()
        self.image.isSkeletonable = false
        self.title_label.isHidden = true
       
      }
      
      func makeAsLoader() {
          
        self.image.isSkeletonable = false
        self.title_label.isHidden = true
        
        self.image.showAnimatedGradientSkeleton()
          
      }

}
