//
//  ProductSearch.swift
//  NearbyStores
//
//  Created by Amine  on 8/21/19.
//  Copyright © 2019 Amine. All rights reserved.
//

import Foundation
import UIKit
import SkyFloatingLabelTextField
import RealmSwift


class UserSearch: MySearchView, UITextFieldDelegate {
    
    var ex_parameters: [String: String] = [
           "__req_search": ""
       ]


    @IBOutlet weak var stackView: UIStackView!
    @IBOutlet weak var search_field: SkyFloatingLabelTextField!
    @IBOutlet weak var radius_label: UILabel!
    @IBOutlet weak var sliderView: UISlider!

    @IBAction func radiusSlide(_ sender: Any) {
        
        let slider: UISlider = sender as! UISlider
        let value = Int(slider.value)
        
        if value < 100  {
            radius_label.text = "\("Radius".localized) \(value) \(AppConfig.distanceUnit.localized)"
        }else{
            radius_label.text = "\("Radius".localized) +\(value) \(AppConfig.distanceUnit.localized)"
        }
        
    }
    
    var selected_category: Category? = nil
    
    
    override func setup() {
        
        guard !initialized else {
            return
        }
        
        super.setup()
       
        self.radius_label.initDefaultFont()
        self.search_field.initDefaultFont()
        self.search_field.titleLabel.initDefaultFont()
        
        self.radius_label.text = "\("Radius".localized) \(AppConfig.distanceMaxValue) \(AppConfig.distanceUnit.localized)"
         self.search_field.textColor = Colors.black
              self.search_field.lineColor = UIColor.gray
              self.search_field.selectedTitleColor = Colors.black
              self.search_field.selectedLineColor = Colors.primaryColor
              self.search_field.selectedLineHeight = 1.5
              self.search_field.lineHeight = 0.5
              self.search_field.titleColor = Colors.primaryColor
              self.search_field.titleLabel.textColor = Colors.black
              
        self.search_field.placeholder = "Product title ...".localized
      

        self.sliderView.minimumValue = Float(0)
        self.sliderView.maximumValue = Float(AppConfig.distanceMaxValue)
        self.sliderView.value = Float(AppConfig.distanceMaxValue)
        
        self.sliderView.tintColor = Colors.primaryColor

        self.radius_label.text = "\("Radius".localized) +\(999) \(AppConfig.distanceUnit.localized)"
    
        self.search_field.delegate = self
        
        NotificationCenter.default.addObserver(self, selector: #selector(handleKeyboardNotification), name: UIResponder.keyboardWillHideNotification, object: nil)
        
        NotificationCenter.default.addObserver(self, selector: #selector(handleKeyboardNotification), name: UIResponder.keyboardWillShowNotification, object: nil)
          
    }
   
   

      @objc func handleKeyboardNotification(notification: NSNotification) {
          
          let isKeyboardShowing = notification.name == UIResponder.keyboardWillShowNotification
          
          if isKeyboardShowing{
              // so increase contentView's height by keyboard height
              UIView.animate(withDuration: 0.3, animations: {
                  //self.constraintContentHeight.constant = -100
                  self.layoutIfNeeded()
              })
              
          }else{
              // so increase contentView's height by keyboard height
              UIView.animate(withDuration: 0.3, animations: {
                  //self.constraintContentHeight.constant = 0
                  self.layoutIfNeeded()
              })
              
          }
          
          
      }
      
      
      var nbrPress = 0
      override func touchesBegan(_ touches: Set<UITouch>, with event: UIEvent?) {
          self.endEditing(true)
      }
      
      
      
      var lastTextField: UITextField? = nil
        
        func textFieldDidBeginEditing(_ textField: UITextField) {
        
            lastTextField = textField
        }
        
      
      
      func textFieldShouldReturn(_ textField: UITextField) -> Bool {
          textField.resignFirstResponder()
          lastTextField = textField
          return true
      }
    
    
    
    func onChange(key: String, activeView: UIButton, views: [String : UIButton]) {
        
      
    }
    
    
  
    
  
    
}
