//
//  CategoryParser.swift
//  NearbyStores
//
//  Created by Amine on 7/12/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit

class FilterParser: Parser {
    
    func parse() -> [FilterObject] {
        
        var list = [FilterObject]()
        
        if let myResult = self.result {
            
            
            if myResult.count > 0 {
                
                let size = myResult.count-1
                
                for index in 0...size {
                    
                    let object = myResult[ String(index) ]
                    
                    
                    let myObject = FilterObject()
                    
                    myObject.id = object["id"].intValue
                    myObject.title = object["title"].stringValue
                    myObject.group = object["type"].stringValue
                    myObject.group_title = object["group_title"].stringValue
                    myObject.order = object["_order"].intValue
                    
                    if object["type"].intValue == 1{
                        myObject.isMultiple = true
                    }else{
                        myObject.isMultiple = false
                    }

                    list.append(myObject)
                    
                }
                
                
            }
            
            
            return list
        }
        
        return []
    }
}
