//
//  AppStyle.swift
//  NSApplication1.8
//
//  Created by Amine  on 5/20/20.
//  Copyright © 2020 Amine. All rights reserved.
//

class AppStyle {
    
    enum uiColor {
        static let light = 1
        static let dark = 2
    }

    
    struct Config {
        //Config Colors & Fonts
        static let uiColor = AppStyle.uiColor.light
    }
    
}



class CardTagsV1 {
    static let TAG_SLIDERS = "slider"
    static let TAG_RECENT_PRODUCTS = "recent_products"
    static let TAG_RELATED_PRODUCTS = "Related products"
    static let TAG_RECENT_OFFERS = "recent_offers"
    static let TAG_DICOUNT_NEAR_YOU = "discount_near_you"
    static let TAG_FEATURED_PRODUCTS = "featured_products"
    static let TAG_TOP_SELLER_PRODUCTS = "top_seller"
    static let TAG_PICK_PRODUCTS = "top_picks_for_you"
    static let TAG_FEATURED_STORES = "featured_stores"
    static let TAG_NEARBY_STORES = "nearby_stores"
    static let TAG_NEARBY_SHOPS = "nearby_shops"
    static let TAG_TOP_RATED = "top_rated"
    static let TAG_NEARBY_PRODUCTS = "nearby_products"
    static let TAG_NEARBY_OFFERS = "nearby_offers"
    static let TAG_TOP_CATEGORIES = "top_categories"
    static let TAG_BEST_SELLER = "best_seller"
    static let TAG_NEARBY_USERS = "Nearby users"
    
}



extension AppConfig.Design{
    
    //HOME page V2
    static let homeList: [CardStyle] = [
        CardHorizontalStyle(width: 320, height: 180, type: .Sliders),
        CardHorizontalStyle(width: 180, height: 180, type: .TopCategories,title: CardTagsV1.TAG_TOP_CATEGORIES),
        CardHorizontalStyle(width: 220, height: 250, type: .FeaturedProducts,title: CardTagsV1.TAG_PICK_PRODUCTS),
        CardHorizontalStyle(width: 220, height: 250, type: .TopSellerProducts,title: CardTagsV1.TAG_TOP_SELLER_PRODUCTS),
        
        
        CardHorizontalStyle(width: 220, height: 250, type: .TopProductInCategory1),
        CardHorizontalStyle(width: 220, height: 250, type: .TopProductInCategory2),
        CardHorizontalStyle(width: 220, height: 250, type: .TopProductInCategory3),
        
        
        CardHorizontalStyle(width: 220, height: 250, type: .Recent_Products,title: CardTagsV1.TAG_RECENT_PRODUCTS),
        
        CardHorizontalStyle(width: 360, height: 220, type: .Nearby_Offers,title: CardTagsV1.TAG_DICOUNT_NEAR_YOU),
        CardHorizontalStyle(width: 250, height: 150, type: .Delievry),
        CardHorizontalStyle(width: 280, height: 270, type: .Nearby_Stores,title: CardTagsV1.TAG_NEARBY_SHOPS),
        CardHorizontalStyle(width: 210, height: 170, type: .Nearby_Users,title: AppConfig.CardTags.TAG_NEARBY_USERS),
    ]

}

extension AppConfig{

    static var CardTags = CardTagsV1.self
    
}

enum MenuPositions {
    case TOP
    case BOTTOM
}

class AppStructV1{
    
    //Main Config
    enum Tags {
        static let TAG_STORES = "stores"
        static let TAG_PRODUCTS = "products"
        static let TAG_OFFERS = "offers"
        static let TAG_INBOX = "inbox"
        static let TAG_GEO = "geo_stores"
        static let TAG_HOME = "home"
    }
    
    static var Pages: [String] = [
        Tags.TAG_OFFERS, // stores
        Tags.TAG_PRODUCTS, // products
        Tags.TAG_STORES, // stores
        Tags.TAG_INBOX,  // Inbox
    ]
    
    static var TabIcons: [String: String] = [
        Tags.TAG_OFFERS: "tab_icon_2",
        Tags.TAG_PRODUCTS: "tab_icon_7",
        Tags.TAG_STORES: "tab_icon_1",
        Tags.TAG_INBOX:  "tab_icon_4",
    ]
    
    static var MenuPosition: MenuPositions = MenuPositions.TOP
}

class AppStructHomeView_With_GeoMaps{
    
    //Main Config
    enum Tags {
        static let TAG_STORES = "stores"
        static let TAG_PRODUCTS = "products"
        static let TAG_OFFERS = "offers"
        static let TAG_INBOX = "inbox"
        static let TAG_GEO = "geo_stores"
        static let TAG_HOME = "home"
    }
    
    static var Pages: [String] = [
        Tags.TAG_HOME, // home page
        Tags.TAG_GEO, // home page
        Tags.TAG_INBOX,  // Inbox
    ]
    
    static var TabIcons: [String: String] = [
        Tags.TAG_HOME: "tab_icon_home",
        Tags.TAG_GEO:  "tab_icon_6",
        Tags.TAG_INBOX:  "tab_icon_4",
    ]
    
    static var MenuPosition: MenuPositions = MenuPositions.BOTTOM
    
}


class AppStructHomeViewV3{
    
    //Main Config
    enum Tags {
        static let TAG_STORES = "stores"
        static let TAG_PRODUCTS = "products"
        static let TAG_OFFERS = "offers"
        static let TAG_INBOX = "inbox"
        static let TAG_GEO = "geo_stores"
        static let TAG_HOME = "home"
        static let TAG_FAVOURITES = "Favourites"
        static let TAG_NOTIFICATION = "notification"
        static let TAG_ACCOUNT = "account"
    }
    
    static var Pages: [String] = [
        Tags.TAG_HOME, // home page
        Tags.TAG_FAVOURITES,
        Tags.TAG_NOTIFICATION, // home page
        Tags.TAG_ACCOUNT,  // Inbox
    ]
    
    static var TabIcons: [String: [String]] = [
        Tags.TAG_HOME: ["dashboard-home","dashboard-home-selected"],
        Tags.TAG_FAVOURITES:  ["dashboard-favourites", "dashboard-favourites-selected"],
        Tags.TAG_NOTIFICATION:  ["dashboard-notifications", "dashboard-notifications-selected"],
        Tags.TAG_ACCOUNT:  ["dashboard-account", "dashboard-account-selected"],
    ]
    
    static var MenuPosition: MenuPositions = MenuPositions.BOTTOM
    
}

