//
//  AppConfig.swift
//  AppTest
//
//  Created by Amine on 5/14/18.
//  Copyright © 2018 Amine. All rights reserved.
//

import UIKit
import SwiftIcons
import PassKit

class AppConfig: NSObject {
    
    //AppConfiguration
    static let DEBUG: Bool = true
    
    //Maps Config
    static let GOOGLE_MAPS_KEY = "*** GOOGLE MAPS KEY ***"
    static let GOOGLE_PLACES_KEY = GOOGLE_MAPS_KEY
    
    
    //API SERVER CONFIG
    struct Api {
        static let ios_api              = "*** iOS API key ***"    // get it from dashboard
        static let base_url             = "https://domain.com"
        static let base_url_api         = "https://domain.com/api"
        static let terms_of_use_url     = "https://domain.com/term_of_uses.html"
        static let privacy_policy_url   = "https://domain.com/privacy_policy.html"
    }
    
    struct DeepLinking {
        
        static let host                   = "domain.com"
        
    }
    
    struct ApplePayConfig {
        static let merchantIdentifier                       = "merchant.{bundle_id}"
        static let supportedNetworks: [PKPaymentNetwork]    = [.visa, .masterCard,.amex,.discover]
        static let supportedCountries: Set<String>?         = ["US"]
        static let codeCountry                              = "US"
    }
    
    
    //App Name
    static let APP_NAME = Bundle.main.infoDictionary?["CFBundleName"] as! String
    
    //Enable/Disable Chat in your App
    static let CHAT_ENABLED = true
    
    
    
    //Config Colors & Fonts
    struct Design {
        
        //Some proposed colors from google
        //https://material.io/design/color/the-color-system.html
        enum Colors {
            
            static let primaryColor = "#ff4800"
            static let accentColor = "#ff632b"
            static let darkColor = "#d33e08"
            
            /* Background Colors */
            static let first_color = "#ff4800"
            static let second_color = "#ff8300"
            
            static let blackColor = "#050000"

            static let featuredTagColor = "#1565C0"
            static let promoTagColor = "#E53935"
            static let dealColor = "#F4B400"
            static let upComingColor = "#E65100"
        }
        
        //See how to set custom font
        //https://developer.apple.com/documentation/uikit/text_display_and_fonts/adding_a_custom_font_to_your_app
        enum Fonts {
            static let regular = "Montserrat-Regular"
            static let italic = "Montserrat-Italic"
            static let bold = "Montserrat-SemiBold"
        }
        
      
    }
    
    static var HomeStruct = AppStructHomeViewV3.self
    

    static var distanceMaxValue = 100 //By KM
    static var distanceUnit = Distance.Types.Kilometers
    
    struct FilterProductConfig {
        static let priceRangeMin = 0
        static let priceRangeMax = 10000
    }
    
    
    struct Settings {
        static let useAsBusinessManeger = false
        static let enableSocialMediaAuth = true
    }
    
    //Enable/Disable Menu Items
    struct Menu {
        /*
         to manage menu list, should remove each id from the list
         */
        static let list = [
            MenuIDList.CATEGORIES : true,
            MenuIDList.GEO_STORES : true,
            MenuIDList.WALLET : true,
            MenuIDList.MY_ORDERS : true,
            MenuIDList.CHAT_LOGIN : true,
            MenuIDList.PEOPLE_AROUND_ME : false,
            MenuIDList.FAVOURITES : true,
            MenuIDList.EDIT_PROFILE : true,
            MenuIDList.LOGOUT : true,
            MenuIDList.MANAGE_STORES : true,
            MenuIDList.SETTING : true,
            MenuIDList.ABOUT : true,
            MenuIDList.CLOSE : true,
            
            ]
    }
    
    let app_version = "3.0.2" // please don't touch this
    
    
    
    
}
