package com.droideve.apps.dealify.utils;

import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import android.widget.TextView;

import androidx.annotation.RequiresApi;
import androidx.core.content.res.ResourcesCompat;
import androidx.fragment.app.FragmentActivity;

import com.droideve.apps.dealify.R;
import com.droideve.apps.dealify.classes.Notification;
import com.droideve.apps.dealify.controllers.cart.CartController;
import com.droideve.apps.dealify.controllers.sessions.SessionsController;
import com.droideve.apps.dealify.dtmessenger.MessengerHelper;
import com.mikepenz.actionitembadge.library.ActionItemBadge;
import com.mikepenz.community_material_typeface_library.CommunityMaterial;
import com.mikepenz.iconics.IconicsDrawable;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

import static com.droideve.apps.dealify.activities.MainActivity.mainMenu;

public class BadgeNotificationUtils {


    @RequiresApi(api = Build.VERSION_CODES.N)
    public int solution2(String[] A) {

        Map<String, Integer> counterDepartment = new HashMap<>();
        for (int i = 0; i < A.length; i++) {
            if (counterDepartment.containsKey(A[i])) {
                counterDepartment.put(A[i], counterDepartment.get(A[i]) + 1);
            } else {
                counterDepartment.put(A[i], 1);
            }
        }
        return (Collections.max(counterDepartment.values()));

    }


    @RequiresApi(api = Build.VERSION_CODES.N)
    public int solution(int[] A) {
        int result = 0;
        if (A.length > 0) {

            Arrays.sort(A);
            int min = A[0];
            int max = Arrays.stream(A).max().getAsInt();
            int searchable = min;

            for (int i = 0; i < A.length; i++) {
                searchable++;
                if (searchable != A[i]) result = searchable;
                else result = max + 1;
            }

        }

        return result;
    }


    public static void updateMessengerBadge(FragmentActivity activity) {

        try {

            if (MessengerHelper.NbrMessagesManager.getNbrTotalMessages() > 0) {
                Drawable msgIcon = new IconicsDrawable(activity)
                        .icon(CommunityMaterial.Icon.cmd_comment_multiple_outline)
                        .color(ResourcesCompat.getColor(activity.getResources(), R.color.color_toolbar_action, null))
                        .sizeDp(18);
                ActionItemBadge.update(activity, mainMenu.findItem(R.id.messenger_action), msgIcon,
                        ActionItemBadge.BadgeStyles.RED,
                        MessengerHelper.NbrMessagesManager.getNbrTotalMessages());
            } else {
                ActionItemBadge.hide(mainMenu.findItem(R.id.messenger_action));
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

    }


    public static void updateNotificationBadge(FragmentActivity activity) {

        try {

            Drawable pinIcon = new IconicsDrawable(activity)
                    .icon(CommunityMaterial.Icon.cmd_bell_outline)
                    .color(ResourcesCompat.getColor(activity.getResources(), R.color.color_toolbar_action, null))
                    .sizeDp(18);

            if (Notification.notificationsUnseen > 0) {
                ActionItemBadge.update(activity, mainMenu.findItem(R.id.notification_action), pinIcon,
                        ActionItemBadge.BadgeStyles.RED, Notification.notificationsUnseen);
            } else {
                ActionItemBadge.hide(mainMenu.findItem(R.id.notification_action));
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static void updateCartItemsBadge(FragmentActivity activity) {

        try {

            int itemCounter = 0;
            if (SessionsController.isLogged()
                    && CartController.productCartCounter(SessionsController.getSession().getUser().getId()) > 0) {
                itemCounter = CartController.productCartCounter(SessionsController.getSession().getUser().getId());
            }

            Drawable pinIcon = new IconicsDrawable(activity)
                    .icon(CommunityMaterial.Icon.cmd_cart_outline)
                    .color(ResourcesCompat.getColor(activity.getResources(), R.color.color_toolbar_action, null))
                    .sizeDp(18);

            if (itemCounter > 0) {
                ActionItemBadge.update(activity, mainMenu.findItem(R.id.cart_icon), pinIcon,
                        ActionItemBadge.BadgeStyles.RED, itemCounter);
            } else {
                ActionItemBadge.update(activity, mainMenu.findItem(R.id.cart_icon), pinIcon,
                        ActionItemBadge.BadgeStyles.GREY, Integer.MIN_VALUE);
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

    }

    public static void updateCartItemsBadgeView(View cartView) {

        try {

            int itemCounter = 0;
            if (SessionsController.isLogged()
                    && CartController.productCartCounter(SessionsController.getSession().getUser().getId()) > 0) {
                itemCounter = CartController.productCartCounter(SessionsController.getSession().getUser().getId());
            }

            if (itemCounter > 0) {
                ((TextView)cartView).setVisibility(View.VISIBLE);
                ((TextView)cartView).setText(String.valueOf(itemCounter));
            }else{
                ((TextView)cartView).setVisibility(View.GONE);
                ((TextView)cartView).setText("0");
            }

        } catch (Exception e) {
            e.printStackTrace();
        }

    }


}
