package com.droideve.apps.dealify.parser.api_parser;

import com.droideve.apps.dealify.classes.Option;
import com.droideve.apps.dealify.parser.Parser;

import org.json.JSONException;
import org.json.JSONObject;

import io.realm.RealmList;

public class OptionParser extends Parser {

    public OptionParser(Parser parser) {
        this.json = parser.json;
    }

    public OptionParser(JSONObject json) {
        super(json);
    }


    public RealmList<Option> getOptions() {

        RealmList<Option> list = new RealmList<Option>();

        try {
            
            for (int i = 0; i < json.length(); i++) {


                JSONObject json_options = json.getJSONObject(i + "");
                Option option = new Option();

                option.setId(json_options.getInt("id"));
                option.setProduct_id(json_options.getInt("product_id"));
                option.setParent_id(json_options.getInt("parent_id"));
                option.setLabel(json_options.getString("label"));
                option.setValue(json_options.getDouble("value"));
                option.setOption_type(json_options.getString("option_type"));
                option.set_order(json_options.getInt("_order"));
                option.setCreated_at(json_options.getString("created_at"));
                option.setUpdated_at(json_options.getString("updated_at"));
                option.setParsed_value(json_options.getString("parsed_value"));

                list.add(option);

            }

        } catch (JSONException e) {
            e.printStackTrace();
        }


        return list;
    }
}
