package com.droideve.apps.dealify.fragments.orderFrags;

import android.content.Context;
import android.graphics.Typeface;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;

import androidx.fragment.app.Fragment;

import com.bumptech.glide.Glide;
import com.droideve.apps.dealify.R;
import com.droideve.apps.dealify.animation.ImageLoaderAnimation;
import com.droideve.apps.dealify.appconfig.Constances;
import com.droideve.apps.dealify.classes.Cart;
import com.droideve.apps.dealify.controllers.SettingsController;
import com.droideve.apps.dealify.network.api_request.ApiRequest;
import com.droideve.apps.dealify.network.api_request.ApiRequestListeners;
import com.droideve.apps.dealify.parser.Parser;
import com.droideve.apps.dealify.utils.MessageDialog;
import com.droideve.apps.dealify.utils.NSLog;
import com.droideve.apps.dealify.utils.ProductUtils;
import com.droideve.apps.dealify.utils.Utils;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.rengwuxian.materialedittext.MaterialEditText;

import java.text.DecimalFormat;
import java.util.Map;

import static android.widget.LinearLayout.HORIZONTAL;
import static android.widget.LinearLayout.VERTICAL;
import static com.droideve.apps.dealify.activities.OrderCheckoutActivity.mCart;
import static com.droideve.apps.dealify.activities.OrderCheckoutActivity.mDefaultItemConfig;
import static com.droideve.apps.dealify.activities.OrderCheckoutActivity.orderFields;

import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import butterknife.BindView;
import butterknife.ButterKnife;
import butterknife.OnClick;


public class ConfirmationFragment extends Fragment {

    private Context mContext;
    private float totalPriceCart = 0;

    @BindView(R.id.applied_discount_container)
    LinearLayout applied_discount_container;
    @BindView(R.id.add_coupon_container)
    LinearLayout add_coupon_container;

    public double appliedDiscountedValue = 0;

    public static String mAppliedDiscountedCode = null;
    public static JSONArray mConfirmationCartAppliedDiscount = new JSONArray();


    @BindView(R.id.total_price)
    TextView total_price;

    @OnClick(R.id.addCoupon)
    void addCoupon() {

        BottomSheetDialog bottomDialog = new BottomSheetDialog(getActivity());
        bottomDialog.setCancelable(true);
        bottomDialog.setContentView(R.layout.bottom_sheet_coupon);
        bottomDialog.show();

        MaterialEditText myField = bottomDialog.findViewById(R.id.codeCouponField);

        NSLog.e("logs", mJsonCart.toString());
        NSLog.e("logs", mJsonCart.toString());


        //Update booking Status
        bottomDialog.findViewById(R.id.applyCoupon).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {

                appliedDiscountedValue = 0;
                mAppliedDiscountedCode = myField.getText().toString();

                ApiRequest.newPostInstance(Constances.API.API_APPLY_COUPON, new ApiRequestListeners() {
                    @Override
                    public void onSuccess(Parser parser) {
                        parse_coupon_application(parser);
                        bottomDialog.dismiss();
                    }

                    @Override
                    public void onFail(Map<String, String> errors) {
                        MessageDialog.showMessage(getActivity(), errors);
                        bottomDialog.dismiss();
                    }
                }, Map.of(
                        "code", mAppliedDiscountedCode,
                        "cart", mJsonCart.toString()
                ));


            }
        });

    }

    @OnClick(R.id.cancelDiscount)
    void onCancelDiscount(){
        mConfirmationCartAppliedDiscount = new JSONArray();
        parserInputViews(mRootView);
    }

    private void parse_coupon_application(Parser parser) {

        double newOrderTotalPrice = 0;
        int TotalOfPercent = 0;

        if (parser.getSuccess() == 1) {

            mConfirmationCartAppliedDiscount = new JSONArray();
            try {
                JSONArray json = new JSONArray(parser.getStringAttr("result"));


                for (int i = 0; i < json.length(); i++) {
                    JSONObject object = json.getJSONObject(i);
                    mConfirmationCartAppliedDiscount.put(i, object);
                    appliedDiscountedValue += object.getDouble("discountedAmount");
                    TotalOfPercent += object.getDouble("discount");
                    newOrderTotalPrice += object.getDouble("amount");
                }

                TotalOfPercent = TotalOfPercent / json.length();

                NSLog.e("AppliedDisocunt", mConfirmationCartAppliedDiscount.toString());

            } catch (JSONException e) {
                e.printStackTrace();
            }

            if (appliedDiscountedValue > 0)
                appliedDiscountedValue = appliedDiscountedValue * -1;


            //display the code discount
            ((TextView) applied_discount_container.findViewById(R.id.applied_discount_label)).setText(
                    String.format(getString(R.string.applied_coupon), mAppliedDiscountedCode, String.valueOf(TotalOfPercent)+"%" )
            );

            //Display discount amount
            ((TextView) applied_discount_container.findViewById(R.id.applied_discount)).setText(
                    ProductUtils.parseCurrencyFormat(
                            (float) appliedDiscountedValue,
                            mDefaultItemConfig.getCurrency())
            );

            newOrderTotalPrice = newOrderTotalPrice + appliedDiscountedValue;

            //Display discount order total
            total_price.setText(ProductUtils.parseCurrencyFormat(
                    (float) newOrderTotalPrice, mDefaultItemConfig.getCurrency()));

            applied_discount_container.setVisibility(View.VISIBLE);
            add_coupon_container.setVisibility(View.GONE);

        } else {
            MessageDialog.showMessage(getActivity(), parser.getErrors());
        }


    }

    public ConfirmationFragment() {
    }

    View mRootView;
    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View root = inflater.inflate(R.layout.fragment_confirmation, container, false);
        mContext = root.getContext();
        mRootView = root;

        mConfirmationCartAppliedDiscount = new JSONArray();
        mAppliedDiscountedCode = null;

        ButterKnife.bind(this, root);

        parserInputViews(root);

        return root;
    }

    @Override
    public void onStart() {
        super.onStart();
    }


    public void calculateTotalPrice(View view) {

        totalPriceCart = 0;

        if (mCart == null || mCart.size() == 0) return;

        for (Cart c : mCart) {
            if (c.getAmount() <= 0) {
                totalPriceCart = 0;
                return;
            } else {
                totalPriceCart += c.getAmount() * c.getQte();
            }
        }

    }


    private void parserInputViews(View view) {

        //init couppon view
        applied_discount_container.setVisibility(View.GONE);

        if (SettingsController.isModuleEnabled("coupons")) {
            add_coupon_container.setVisibility(View.VISIBLE);
        }else{
            add_coupon_container.setVisibility(View.GONE);
        }


        //generate products
        generateProductFromCart(view);

        //calculate total price
        calculateTotalPrice(view);

        //geneate custom fields
        generateCustomFields(view);


        if (mDefaultItemConfig != null) {

            //product PRICE
            if (mDefaultItemConfig.getCurrency() != null) {

                if (mDefaultItemConfig.getProduct_type().equalsIgnoreCase("percent") && (mDefaultItemConfig.getProduct_value() > 0 || mDefaultItemConfig.getProduct_value() < 0)) {
                    DecimalFormat decimalFormat = new DecimalFormat("#0");
                    ((TextView) view.findViewById(R.id.total_price)).setText(ProductUtils.parseCurrencyFormat(
                            0, mDefaultItemConfig.getCurrency()));
                } else {
                    if (mDefaultItemConfig.getProduct_type().equalsIgnoreCase("Price") && mDefaultItemConfig.getProduct_value() != 0) {

                        ((TextView) view.findViewById(R.id.total_price)).setText(ProductUtils.parseCurrencyFormat(
                                totalPriceCart,
                                mDefaultItemConfig.getCurrency()));

                    } else {
                        ((TextView) view.findViewById(R.id.price_product)).setText(getString(R.string.promo));
                        ((TextView) view.findViewById(R.id.total_price)).setText(getString(R.string.promo));
                    }
                }


            }
        }


    }


    JSONArray mJsonCart = new JSONArray();

    public void generateProductFromCart(View view) {

        //global fields
        LinearLayout.LayoutParams lp_match_wrap = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);
        LinearLayout.LayoutParams lp_wrap_wrap = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT);

        LinearLayout itemWrapper = view.findViewById(R.id.products_container);
        itemWrapper.removeAllViews();


        if (mCart == null || mCart.size() == 0) return;

        int i = 0;
        mJsonCart = new JSONArray();

        for (Cart c : mCart) {

            if (c.getOrderableItem() == null) return;

            //built static content
            LinearLayout product_detail_layout = new LinearLayout(mContext);
            LinearLayout.LayoutParams product_detail_layout_lp = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);
            product_detail_layout_lp.setMargins(0, (int) getResources().getDimension(R.dimen.spacing_medium), 0, 0);
            product_detail_layout.setOrientation(HORIZONTAL);
            product_detail_layout.setLayoutParams(product_detail_layout_lp);


            ImageView image_product = new ImageView(mContext);
            image_product.setScaleType(ImageView.ScaleType.CENTER_CROP);
            LinearLayout.LayoutParams layout_916 = new LinearLayout.LayoutParams(120, 120);
            image_product.setLayoutParams(layout_916);
            product_detail_layout.addView(image_product);


            LinearLayout sub_layout = new LinearLayout(mContext);
            sub_layout.setPaddingRelative((int) getResources().getDimension(R.dimen.spacing_medium), 0, 0, 0);
            sub_layout.setOrientation(VERTICAL);
            LinearLayout.LayoutParams lp_match_wrap_c1 = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);
            lp_match_wrap_c1.setMarginStart((int) getResources().getDimension(R.dimen.spacing_medium));
            sub_layout.setLayoutParams(lp_match_wrap_c1);

            LinearLayout linearLayout_512 = new LinearLayout(mContext);
            linearLayout_512.setOrientation(HORIZONTAL);

            linearLayout_512.setLayoutParams(lp_match_wrap);

            TextView title_product = new TextView(mContext);
            title_product.setId(R.id.title_product);
            title_product.setTextColor(getResources().getColor(R.color.black));
            title_product.setTextAlignment(View.TEXT_ALIGNMENT_VIEW_START);
            LinearLayout.LayoutParams lp_match_wrap_c2 = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);
            lp_match_wrap_c2.weight = 1;
            title_product.setLayoutParams(lp_match_wrap_c2);
            linearLayout_512.addView(title_product);

            TextView price_product = new TextView(mContext);
            price_product.setId(R.id.price_product);
            price_product.setTextAlignment(View.TEXT_ALIGNMENT_VIEW_END);
            price_product.setTypeface(price_product.getTypeface(), Typeface.BOLD);
            price_product.setTextColor(getResources().getColor(R.color.black));
            price_product.setLayoutParams(lp_wrap_wrap);
            linearLayout_512.addView(price_product);
            sub_layout.addView(linearLayout_512);

            TextView desc_product = new TextView(mContext);
            desc_product.setId(R.id.desc_product);
            desc_product.setTextColor(getResources().getColor(R.color.black));
            LinearLayout.LayoutParams lp_match_wrap_c3 = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);
            lp_match_wrap_c3.topMargin = (int) getResources().getDimension(R.dimen.spacing_medium);
            desc_product.setLayoutParams(lp_match_wrap_c3);


            //dynamic content

            //product image
            if (c.getOrderableItem().getImages() != null && c.getOrderableItem().getImages().getUrl100_100() != null)
                Glide.with(mContext)
                        .load(c.getOrderableItem().getImages()
                                .getUrl100_100())
                        .placeholder(ImageLoaderAnimation.glideLoader(mContext))
                        .centerCrop()
                        .into(image_product);

            title_product.setText(c.getOrderableItem().getName());

            if (c.getOrderableItem().getProduct_type().equalsIgnoreCase("percent") && (c.getOrderableItem().getProduct_value() > 0 || c.getOrderableItem().getProduct_value() < 0)) {
                price_product.setText(ProductUtils.parseCurrencyFormat(0, c.getOrderableItem().getCurrency()));


            } else {
                if (c.getOrderableItem().getProduct_type().equalsIgnoreCase("Price") && c.getOrderableItem().getProduct_value() != 0) {

                    price_product.setText(ProductUtils.parseCurrencyFormat(
                            (float) (c.getAmount() * c.getQte()),
                            c.getOrderableItem().getCurrency()));

                    try {
                        JSONObject item = new JSONObject();
                        item.put("item_id", c.getModule_id());
                        item.put("amount", c.getAmount() * c.getQte());
                        mJsonCart.put(i, item);
                        i++;
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }

                } else {
                    price_product.setText(getString(R.string.promo));
                }
            }


            desc_product.setText(String.format(getString(R.string.order_qty), c.getQte()));

            sub_layout.addView(desc_product);

            product_detail_layout.addView(sub_layout);

            itemWrapper.addView(product_detail_layout);
        }


    }

    private void generateCustomFields(View view) {

        LinearLayout itemWrapper = view.findViewById(R.id.inputs_fields_wrapper);
        itemWrapper.setOrientation(VERTICAL);
        itemWrapper.setPaddingRelative((int) getResources().getDimension(R.dimen.spacing_large), 0, 0, 0);
        LinearLayout.LayoutParams layout_336 = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);
        itemWrapper.setLayoutParams(layout_336);

        itemWrapper.removeAllViews();

        if (orderFields != null) {

            for (Map.Entry<String, String> entry : orderFields.entrySet()) {


                LinearLayout itemLayoutView = new LinearLayout(mContext);
                itemLayoutView.setOrientation(VERTICAL);
                LinearLayout.LayoutParams layout_379 = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);
                layout_379.setMargins(Utils.dpToPx(5), Utils.dpToPx(3), Utils.dpToPx(3), Utils.dpToPx(3));
                itemLayoutView.setLayoutParams(layout_379);

                TextView titleField = new TextView(mContext);
                titleField.setText(entry.getKey());
                titleField.setTypeface(titleField.getTypeface(), Typeface.BOLD);
                titleField.setTextColor(getResources().getColor(R.color.black));
                titleField.setTextAlignment(View.TEXT_ALIGNMENT_VIEW_START);
                LinearLayout.LayoutParams layout_143 = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.MATCH_PARENT, LinearLayout.LayoutParams.WRAP_CONTENT);
                layout_143.weight = 1;
                titleField.setLayoutParams(layout_143);
                itemLayoutView.addView(titleField);


                TextView valueField = new TextView(mContext);
                String value = entry.getValue().trim();

                //handle the case location : city ; lat ; lng
                if (value != null && value.split(";").length >= 2) {
                    value = value.split(";")[0];
                }


                valueField.setText(value);
                valueField.setTextColor(getResources().getColor(R.color.grey_60));
                valueField.setTextAlignment(View.TEXT_ALIGNMENT_VIEW_END);
                LinearLayout.LayoutParams layout_655 = new LinearLayout.LayoutParams(LinearLayout.LayoutParams.WRAP_CONTENT, LinearLayout.LayoutParams.WRAP_CONTENT);
               // layout_655.leftMargin = (int) getResources().getDimension(R.dimen.spacing_small);
               // layout_655.rightMargin = (int) getResources().getDimension(R.dimen.spacing_small);
                valueField.setLayoutParams(layout_655);
                itemLayoutView.addView(valueField);


                itemWrapper.addView(itemLayoutView);


            }
        }


    }


}