package com.droideve.apps.dealify.fragments;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStatePagerAdapter;
import androidx.viewpager.widget.ViewPager;

import com.droideve.apps.dealify.R;
import com.droideve.apps.dealify.activities.LoginV2Activity;
import com.droideve.apps.dealify.activities.ProfileActivity;
import com.droideve.apps.dealify.controllers.sessions.SessionsController;
import com.droideve.apps.dealify.utils.NSLog;
import com.droideve.apps.dealify.views.SwipeDisabledViewPager;
import com.google.android.material.bottomnavigation.BottomNavigationView;

import org.greenrobot.eventbus.EventBus;


public class MainFragment extends Fragment {

    public final static String TAG = "mainfragment";
    private static SwipeDisabledViewPager viewPager;
    static BottomNavigationView navigation;
    private Listener mListener;
    private FragmentActivity myContext;


    public static ViewPager getPager() {
        return viewPager;
    }

    public void setListener(final Listener mItemListener) {
        this.mListener = mItemListener;
    }

    public interface Listener {
        void onScrollHorizontal(int position);

        void onScrollVertical(int scrollXs, int scrollY);
    }


    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View rootView = inflater.inflate(R.layout.fragment_main, container, false);

        initViewPagerAdapter(rootView);

        initBottomNavigation(rootView);


        return rootView;
    }

    @Override
    public void onAttach(Activity activity) {
        super.onAttach(activity);
        myContext = (FragmentActivity) activity;
    }


    private void initViewPagerAdapter(View view) {
        ViewPagerAdapter adapter = new ViewPagerAdapter(myContext.getSupportFragmentManager());
        viewPager = view.findViewById(R.id.pager);
        viewPager.setAdapter(adapter);
        viewPager.setOffscreenPageLimit(4);
    }

    @Override
    public void onResume() {
        super.onResume();
    }

    public void setCurrentFragment(int position) {
        navigation.setSelectedItemId(position);
        viewPager.setCurrentItem(position);
    }


    @Override
    public void onStart() {
        super.onStart();
    }

    @Override
    public void onStop() {
        super.onStop();
    }

    @Override
    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setHasOptionsMenu(true);
    }

    @Override
    public void onPrepareOptionsMenu(Menu menu) {
        super.onPrepareOptionsMenu(menu);
    }


    public class ViewPagerAdapter extends FragmentStatePagerAdapter implements  HomeFragment.Listener {

        int FRAGS_ITEMS_NUM = 4;

        public ViewPagerAdapter(FragmentManager fragmentManager) {
            super(fragmentManager);
        }

        // Returns total number of pages
        @Override
        public int getCount() {
            return FRAGS_ITEMS_NUM;
        }

        // Returns the fragment to display for that page
        @Override
        public Fragment getItem(int position) {

            switch (position) {
                case 0:
                    HomeFragment frag = HomeFragment.newInstance(0, "Page # 1");
                    frag.setListener(this);
                    return frag;
                case 1:
                    return BookmarkFragment.newInstance(2, "Page # 2");
                case 2:
                    return NotificationFragment.newInstance(3, "Page # 4");
                case 3:
                    if (SessionsController.isLogged())
                        return ProfileFragment.newInstance(4, "Page # 3");
                    else
                        return AuthenticationFragment.newInstance(4, "Page # 3");
                default:
                    return null;
            }


        }

        // Returns the page title for the top indicator
        @Override
        public CharSequence getPageTitle(int position) {
            return "Page " + position;
        }

        @Override
        public void onScroll(int scrollX, int scrollY) {
            NSLog.e("ViewPagerAdapter", scrollX + " - " + scrollY);
            if (mListener != null)
                mListener.onScrollVertical(scrollX, scrollY);
        }

    }


    private void initBottomNavigation(View view) {

        View navigation_bottom = view.findViewById(R.id.navigation_bottom);
        navigation = navigation_bottom.findViewById(R.id.navigation);

        //setup bottom navigation
        viewPager.setCurrentItem(0);

        navigation.setOnNavigationItemSelectedListener(new BottomNavigationView.OnNavigationItemSelectedListener() {
            @Override
            public boolean onNavigationItemSelected(@NonNull MenuItem item) {
                PageViewEvent mPageViewEvent = new PageViewEvent();
                switch (item.getItemId()) {
                    case R.id.navigation_home:
                        viewPager.setCurrentItem(0);

                        if (mListener != null)
                            mListener.onScrollHorizontal(0);

                        return true;
                    case R.id.navigation_favorites:
                        viewPager.setCurrentItem(1);

                        if (mListener != null)
                            mListener.onScrollHorizontal(1);

                        return true;
                    case R.id.navigation_notification:
                        viewPager.setCurrentItem(2);

                        if (mListener != null)
                            mListener.onScrollHorizontal(2);

                        return true;
                    case R.id.navigation_account:
                        if (SessionsController.isLogged()) {
                            startActivity(new Intent(getActivity(), ProfileActivity.class));
                        }else{
                            startActivity(new Intent(getActivity(), LoginV2Activity.class));
                        }
                }

                EventBus.getDefault().post(mPageViewEvent);
                return true;
            }
        });


    }


    public class PageViewEvent {
        public String title;
        public int position;
    }

}
