package com.droideve.apps.dealify.customview;

import android.content.Context;
import android.util.AttributeSet;
import android.view.Gravity;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;

import com.bumptech.glide.Glide;
import com.droideve.apps.dealify.R;
import com.droideve.apps.dealify.utils.Utils;
import com.rey.material.widget.LinearLayout;

import java.util.ArrayList;
import java.util.List;

public class ProductImageCarousel extends HorizontalScrollView {



    public ProductImageCarousel(Context context) {
        super(context);
    }

    public ProductImageCarousel(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public ProductImageCarousel(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public ProductImageCarousel(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }


    LinearLayout ll;

    public void setup(Context ctx){

        ll = new LinearLayout(ctx);
        ll.setOrientation(android.widget.LinearLayout.HORIZONTAL);

        android.widget.LinearLayout.LayoutParams layoutParams = new android.widget.LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT);
        ll.setPadding(
                Utils.dpToPx(10),
                Utils.dpToPx(10),
                Utils.dpToPx(10),
                0
        );
        ll.setGravity(Gravity.CENTER);
        ll.setLayoutParams(layoutParams);


        addView(ll);

    }

    public ImageView addImage(Context ctx, String url, boolean isActive){


        //setup framlayout
        LayoutParams lp_fp =  new LayoutParams(Utils.dpToPx(70),Utils.dpToPx(70));
        lp_fp.setMargins(
                0,
                Utils.dpToPx(5),
                Utils.dpToPx(10),
                Utils.dpToPx(10)
        );
        FrameLayout fp = new FrameLayout(ctx);
        fp.setLayoutParams(lp_fp);
        fp.setPadding(Utils.dpToPx(5),Utils.dpToPx(5),Utils.dpToPx(5),Utils.dpToPx(5));
        fp.setBackground(ctx.getDrawable(R.drawable.border_image));
        fp.setBackgroundResource(R.drawable.border_image);

        //Setup image view
        LayoutParams lp =  new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        lp.setMargins(
                0,
                0,
                Utils.dpToPx(10),
                Utils.dpToPx(10)
        );
        lp =  new LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.MATCH_PARENT);
        ImageView img = new ImageView(ctx);
        img.setImageDrawable(ctx.getDrawable(R.drawable.def_logo));
        img.setLayoutParams(lp);
        img.setScaleType(ImageView.ScaleType.CENTER_CROP);

        fp.addView(img);
        ll.addView(fp);

        Glide.with(ctx)
                .load(url)
                .centerCrop().placeholder(R.drawable.def_logo)
                .into(img);

        if(!isActive){
            fp.setAlpha((float) 0.7);
        }else
            fp.setAlpha(1);

        views.add(fp);

        numbers++;


        return img;
    }

    public void makeAllAlpha(){
        for(View view : views){
            view.setAlpha((float) 0.7);
        }
    }

    public int numbers = 0;
    public List<View> views = new ArrayList<>();
}
