package com.droideve.apps.dealify.activities;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.PorterDuff;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;

import androidx.appcompat.widget.Toolbar;
import androidx.core.content.res.ResourcesCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransaction;

import com.android.volley.RequestQueue;
import com.droideve.apps.dealify.AppController;
import com.droideve.apps.dealify.R;
import com.droideve.apps.dealify.Services.GenericNotifyEvent;
import com.droideve.apps.dealify.appconfig.AppContext;
import com.droideve.apps.dealify.appconfig.Constances;
import com.droideve.apps.dealify.classes.CF;
import com.droideve.apps.dealify.classes.Cart;
import com.droideve.apps.dealify.classes.Option;
import com.droideve.apps.dealify.classes.OrderableItem;
import com.droideve.apps.dealify.classes.Variant;
import com.droideve.apps.dealify.controllers.SettingsController;
import com.droideve.apps.dealify.controllers.cart.CartController;
import com.droideve.apps.dealify.controllers.sessions.SessionsController;
import com.droideve.apps.dealify.controllers.stores.OffersController;
import com.droideve.apps.dealify.controllers.stores.ProductsController;
import com.droideve.apps.dealify.customview.AdvancedWebViewActivity;
import com.droideve.apps.dealify.fragments.orderFrags.ConfirmationFragment;
import com.droideve.apps.dealify.fragments.orderFrags.OrderInfoFragment;
import com.droideve.apps.dealify.fragments.orderFrags.PaymentFragment;
import com.droideve.apps.dealify.network.VolleySingleton;
import com.droideve.apps.dealify.network.api_request.ApiRequest;
import com.droideve.apps.dealify.network.api_request.ApiRequestListeners;
import com.droideve.apps.dealify.parser.Parser;
import com.droideve.apps.dealify.utils.MessageDialog;
import com.droideve.apps.dealify.utils.NSToast;
import com.google.android.libraries.places.widget.AutocompleteActivity;
import com.google.gson.Gson;

import org.greenrobot.eventbus.EventBus;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import static com.droideve.apps.dealify.security.Security.newInstance;

public class OrderCheckoutActivity extends GlobalActivity {


    //checkout navigation fields
    private enum State {ORDER, PAYMENT, CONFIRMATION}

    State[] array_state = new State[]{State.ORDER, State.CONFIRMATION, State.PAYMENT};
    private View line_first, line_second;
    private ImageView image_shipping, image_payment, image_confirm;
    private TextView tv_shipping, tv_payment, tv_confirm;
    private int idx_state = 0;


    //init static params
    public static HashMap<String, String> orderFields;
    public static int order_id = -1;
    public static int module_id = -1;
    private String module;

    public static OrderableItem mDefaultItemConfig;
    public static List<Cart> mCart;
    public static List<Cart> mAppliedDiscounts;
    public static int PAYMENT_CALLBACK_CODE = 2020;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_order_checkout_step);
        initToolbar();

        initComponent();

        buttonRtlSupp();

        handleIntentAction();


        if (getIntent().hasExtra("fragmentToOpen") && getIntent().hasExtra("order_id")) {
            if (getIntent().getStringExtra("fragmentToOpen").equals("fragment_payment")) {
                order_id = getIntent().getIntExtra("order_id", -1);
                navigateToPaymentFragment();
            }
        } else {
            // display the first fragment as a default page
            displayFragment(State.ORDER);
        }

    }


    private void buttonRtlSupp() {
        //rtl
        if (AppController.isRTL()) {
            ((ImageView) findViewById(R.id.arrow_next)).setImageDrawable(ResourcesCompat.getDrawable(getResources(), R.drawable.forward, null));
            ((ImageView) findViewById(R.id.arrow_previous)).setImageDrawable(ResourcesCompat.getDrawable(getResources(), R.drawable.forward, null));
        } else {
            ((ImageView) findViewById(R.id.arrow_next)).setImageDrawable(ResourcesCompat.getDrawable(getResources(), R.drawable.back, null));
            ((ImageView) findViewById(R.id.arrow_previous)).setImageDrawable(ResourcesCompat.getDrawable(getResources(), R.drawable.back, null));
        }

        ((ImageView) findViewById(R.id.arrow_next)).setColorFilter(getResources().getColor(R.color.white), PorterDuff.Mode.SRC_ATOP);
        ((ImageView) findViewById(R.id.arrow_previous)).setColorFilter(getResources().getColor(R.color.black), PorterDuff.Mode.SRC_ATOP);

    }

    private void handleIntentAction() {
        //checkout from offer
        if (getIntent().hasExtra("module_id") && getIntent().hasExtra("module")) {

            String module = getIntent().getStringExtra("module");

            int module_id = getIntent().getIntExtra("module_id", -1);


            //from order list
            if (getIntent().hasExtra("cart")) {
                try {
                    JSONObject mJsonObject = new JSONObject(getIntent().getStringExtra("cart"));

                    mCart = new ArrayList<>();

                    for (int i = 0; i < mJsonObject.length(); i++) {

                        JSONObject jsonRow = mJsonObject.getJSONObject(String.valueOf(i));
                        Cart c = new Cart();
                        c.setModule_id(jsonRow.getInt("module_id"));
                        c.setModule(jsonRow.getString("module"));
                        c.setAmount(jsonRow.getDouble("amount"));
                        c.setQte(jsonRow.getInt("qty"));
                        mCart.add(c);
                    }


                } catch (JSONException e) {
                    mCart = null;
                }

            } else {
                mCart = Arrays.asList(CartController.findItemByModule(module, module_id));
            }


            if (module.equalsIgnoreCase(Constances.ModulesConfig.OFFER_MODULE))
                mDefaultItemConfig = OffersController.findOfferById(module_id);
            else if (module.equalsIgnoreCase(Constances.ModulesConfig.PRODUCT_MODULE))
                mDefaultItemConfig = ProductsController.findProductById(module_id);

            if (mDefaultItemConfig != null) {
                //disable payment if the modules is disabled or the product_id price equal to 0
                if (!SettingsController.isModuleEnabled(Constances.ModulesConfig.ORDER_PAYMENT_MODULE) || mDefaultItemConfig.getProduct_value() == 0 || mDefaultItemConfig.getProduct_type().equalsIgnoreCase("Percent")) {
                    disablePaymentModule();
                }
            } else {
                NSToast.show(getString(R.string.pleaseTryLater));
                finish();
            }

        } else if (getIntent().hasExtra("fromCart")) { //checkout from cart list
            //get data from database
            mCart = CartController.listProducts(SessionsController.getSession().getUser().getId());
            mDefaultItemConfig = (mCart != null && mCart.size() > 0) ? mCart.get(0).getProduct() : null;
            module = Constances.ModulesConfig.PRODUCT_MODULE;

        } else {
            NSToast.show(getString(R.string.pleaseTryLater));
            finish();
        }


    }

    private void navigateToPaymentFragment() {
        idx_state = array_state.length - 1;
        buttonStatusChange();
        displayFragment(State.PAYMENT);
    }

    private void disablePaymentModule() {
        //hide payment wizard
        RelativeLayout.LayoutParams params = (RelativeLayout.LayoutParams) findViewById(R.id.wizard_confirm).getLayoutParams();
        params.addRule(RelativeLayout.ALIGN_PARENT_RIGHT, RelativeLayout.TRUE);
        params.addRule(RelativeLayout.ALIGN_PARENT_END, RelativeLayout.TRUE);

        findViewById(R.id.wizard_payment).setVisibility(View.GONE);
        //findViewById(R.id.line_second).setVisibility(View.GONE);
        //remove the payment from state list
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.N) {
            array_state = Arrays.stream(array_state)
                    .filter(obj -> !obj.equals(State.PAYMENT))
                    .toArray(State[]::new);
        }
    }


    private void initComponent() {
        line_first = findViewById(R.id.line_first);
        line_second = findViewById(R.id.line_second);
        image_shipping = findViewById(R.id.image_shipping);
        image_payment = findViewById(R.id.image_payment);
        image_confirm = findViewById(R.id.image_confirm);

        tv_shipping = findViewById(R.id.tv_shipping);
        tv_payment = findViewById(R.id.tv_payment);
        tv_confirm = findViewById(R.id.tv_confirm);

        image_payment.setColorFilter(getResources().getColor(R.color.grey_20), PorterDuff.Mode.SRC_ATOP);
        image_confirm.setColorFilter(getResources().getColor(R.color.grey_20), PorterDuff.Mode.SRC_ATOP);

        (findViewById(R.id.lyt_next)).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {


                //check for required field
                if (array_state[idx_state] == State.ORDER)
                    if (checkRequiredFields(mDefaultItemConfig)) {
                        //display error message and cancel the operation
                        NSToast.show(getString(R.string.complet_required_fileds));
                        return;
                    }

                //check content format
                if (!checkRegexFormatField(mDefaultItemConfig)) {
                    //display error message and cancel the operation
                    return;
                }


                //Submit order action
                if (array_state[idx_state] == State.CONFIRMATION) {
                    submitOrderAPI();
                    if (idx_state == array_state.length - 1) {
                        return;

                    }
                }


                // Pay order action
                if (array_state[idx_state] == State.PAYMENT) {

                    if (SettingsController.isModuleEnabled(Constances.ModulesConfig.ORDER_PAYMENT_MODULE) && mDefaultItemConfig.getProduct_value() > 0) {
                        if (PaymentFragment.paymentChoosed == -1) {
                            NSToast.show(getString(R.string.choose_payment_gateway));
                            return;
                        }
                        generatePaymentLinkAPi(v);


                        return;

                    }

                }

                //navigate to the next fragment
                idx_state++;
                displayFragment(array_state[idx_state]);

                //change btton status after click
                buttonStatusChange();

            }
        });

        (

                findViewById(R.id.lyt_previous)).

                setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        if (idx_state < 1) return;
                        idx_state--;
                        displayFragment(array_state[idx_state]);

                        buttonStatusChange();

                    }
                });

    }

    private void showSuccessPage() {

        findViewById(R.id.layout_content).setVisibility(View.GONE);
        findViewById(R.id.layout_done).setVisibility(View.VISIBLE);
        findViewById(R.id.lyt_done).setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                // run event to update  the order list
                EventBus.getDefault().postSticky(new GenericNotifyEvent("order_updated"));

                //display order list
                Intent intent = new Intent(getApplicationContext(),ListOrdersActivity.class);
                startActivity(intent);

                //close current activity
                finish();
            }
        });

        //update color
        findViewById(R.id.lyt_done).setBackgroundColor(getResources().getColor(R.color.green));


    }

    private void buttonStatusChange() {


        if (idx_state == array_state.length - 1) {

            if (mDefaultItemConfig == null)   //if the order is not available close the checkout activity
            {
                NSToast.show(( "Oops!! Order not found..."));
                finish();
                return;
            }

            if (!SettingsController.isModuleEnabled(Constances.ModulesConfig.ORDER_PAYMENT_MODULE) || mDefaultItemConfig.getProduct_value() == 0 || mDefaultItemConfig.getProduct_type().equalsIgnoreCase("Percent")) {
                ((TextView) findViewById(R.id.btn_next)).setText(getString(R.string.confirm_order));
            } else {
                ((TextView) findViewById(R.id.btn_next)).setText(getString(R.string.confirm_payment));
                findViewById(R.id.lyt_previous).setVisibility(View.GONE);
            }

            (findViewById(R.id.arrow_next)).setVisibility(View.GONE);
        } else {
            ((TextView) findViewById(R.id.btn_next)).setText(getString(R.string.next));
            (findViewById(R.id.arrow_next)).setVisibility(View.VISIBLE);
            (findViewById(R.id.lyt_previous)).setVisibility(View.VISIBLE);

        }

    }

    private void initToolbar() {
        Toolbar toolbar = findViewById(R.id.toolbar);
        toolbar.setNavigationIcon(R.drawable.close);
        toolbar.getNavigationIcon().setColorFilter(getResources().getColor(R.color.colorPrimary), PorterDuff.Mode.SRC_ATOP);
        setSupportActionBar(toolbar);
        getSupportActionBar().setTitle(null);
        getSupportActionBar().setDisplayHomeAsUpEnabled(true);

    }

    private void displayFragment(State state) {
        FragmentManager fragmentManager = getSupportFragmentManager();
        FragmentTransaction fragmentTransaction = fragmentManager.beginTransaction();
        Bundle bundle = new Bundle();
        bundle.putInt("module_id", module_id);
        bundle.putString("module", module);


        for (Cart c : mCart) {
            bundle.putInt("store_id",c.getProduct().getStore_id());
        }

        Fragment fragment = null;


        refreshStepTitle();

        if (state.name().equalsIgnoreCase(State.ORDER.name())) {
            fragment = new OrderInfoFragment();
            fragment.setArguments(bundle);
            tv_shipping.setTextColor(getResources().getColor(R.color.colorPrimary));

            image_shipping.clearColorFilter();
            line_first.setBackgroundColor(getResources().getColor(R.color.grey_20));
            line_second.setBackgroundColor(getResources().getColor(R.color.grey_20));
        } else if (state.name().equalsIgnoreCase(State.CONFIRMATION.name())) {
            fragment = new ConfirmationFragment();
            fragment.setArguments(bundle);

            tv_shipping.setTextColor(getResources().getColor(R.color.colorPrimary));
            tv_confirm.setTextColor(getResources().getColor(R.color.colorPrimary));


            line_first.setBackgroundColor(getResources().getColor(R.color.colorPrimary));

            //when payment is disabled
            if (!SettingsController.isModuleEnabled(Constances.ModulesConfig.ORDER_PAYMENT_MODULE) || mDefaultItemConfig.getProduct_value() == 0 || mDefaultItemConfig.getProduct_type().equalsIgnoreCase("Percent")) {
                line_second.setBackgroundColor(getResources().getColor(R.color.colorPrimary));
            }

            image_confirm.clearColorFilter();
        } else if (state.name().equalsIgnoreCase(State.PAYMENT.name())) {

            fragment = new PaymentFragment();
            fragment.setArguments(bundle);

            tv_shipping.setTextColor(getResources().getColor(R.color.colorPrimary));
            tv_payment.setTextColor(getResources().getColor(R.color.colorPrimary));
            tv_confirm.setTextColor(getResources().getColor(R.color.colorPrimary));

            line_first.setBackgroundColor(getResources().getColor(R.color.colorPrimary));
            line_second.setBackgroundColor(getResources().getColor(R.color.colorPrimary));


            image_shipping.setColorFilter(getResources().getColor(R.color.colorPrimary), PorterDuff.Mode.SRC_ATOP);
            image_payment.setColorFilter(getResources().getColor(R.color.colorPrimary), PorterDuff.Mode.SRC_ATOP);
            image_confirm.setColorFilter(getResources().getColor(R.color.colorPrimary), PorterDuff.Mode.SRC_ATOP);

        }

        if (fragment == null) return;
        fragmentTransaction.replace(R.id.frame_content, fragment);
        fragmentTransaction.commit();
    }

    private void refreshStepTitle() {
        tv_shipping.setTextColor(getResources().getColor(R.color.grey_40));
        tv_payment.setTextColor(getResources().getColor(R.color.grey_40));
        tv_confirm.setTextColor(getResources().getColor(R.color.grey_40));
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        //getMenuInflater().inflate(R.menu.menu_setting, menu);
        //Tools.changeMenuIconColor(menu, getResources().getColor(R.color.grey_20));
        return true;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        orderFields = null;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        if (item.getItemId() == android.R.id.home) {
            finish();
        }
        return super.onOptionsItemSelected(item);
    }

    private boolean checkRequiredFields(final OrderableItem mItemOrderble) {

        Boolean result = false;
        if (mItemOrderble != null) {
            for (CF mCF : mItemOrderble.getCf()) {
                if (mCF.getRequired() == 1) {
                    if (orderFields != null && !orderFields.containsKey(mCF.getLabel())
                            || (orderFields.containsKey(mCF.getLabel())
                            && orderFields.get(mCF.getLabel()).trim().length() == 0)) {
                        result = true;
                        break;
                    }
                }

            }
        }
        return result;
    }


    private boolean checkRegexFormatField(final OrderableItem mItemOrderble) {

        Boolean result = true;
        if (mItemOrderble != null) {
            for (CF mCF : mItemOrderble.getCf()) {
                if (mCF.getType() != null) {
                    String[] arrayType = mCF.getType().split("\\.");

                    //check if location field is good
                    if (arrayType.length > 0 && arrayType[1].equals("location")) {
                        if (orderFields != null && orderFields.containsKey(mCF.getLabel())) {
                            String[] locationFormat = orderFields.get(mCF.getLabel()).split(";");
                            if (locationFormat.length != 3) {
                                NSToast.show(( getString(R.string.location_format_not_correct)));
                                result = false;
                                break;
                            } else {
                                if (locationFormat[0].length() == 0) {
                                    NSToast.show((getString(R.string.location_address_not_correct)));
                                    result = false;
                                    break;
                                }
                                //check if float
                                try {
                                    Float.parseFloat(locationFormat[1]);
                                } catch (NumberFormatException e) {
                                    NSToast.show(( getString(R.string.location_format_not_correct)));
                                    result = false;
                                    break;
                                }

                                //check if float
                                try {
                                    Float.parseFloat(locationFormat[2]);
                                } catch (NumberFormatException e) {
                                    NSToast.show(( getString(R.string.location_format_not_correct)));
                                    result = false;
                                    break;
                                }
                            }
                        }
                    }
                }
            }
        }
        return result;
    }


    private void displayPaymentWebView(final String plink) {


        // Encode data on your side using BASE64
        String cryptedLink = newInstance().encrypt(plink);
        String link = Constances.API.API_PAYMENT_LINK_CALL + "?redirect=" + cryptedLink + "&token=" + SessionsController.getSession().getToken();

        if (AppContext.DEBUG)
            Log.e("paymentLink", link);


        Intent intent = new Intent(this, AdvancedWebViewActivity.class);
        intent.putExtra("plink", link);
        startActivityForResult(intent, PAYMENT_CALLBACK_CODE);


    }

    private void submitOrderAPI() {

        RequestQueue queue = VolleySingleton.getInstance(this).getRequestQueue();
        queue = VolleySingleton.getInstance(this).getRequestQueue();
        Gson gson = new Gson();

        final Map<String, String> params = new HashMap<String, String>();

        if (SessionsController.isLogged()) {
            params.put("user_id", SessionsController.getSession().getUser().getId() + "");
        }


        params.put("module", Constances.ModulesConfig.STORE_MODULE);
        params.put("module_id", String.valueOf(mDefaultItemConfig.getStore_id()));
        params.put("req_cf_id", String.valueOf(mDefaultItemConfig.getCf_id()));

        if (orderFields != null && !orderFields.isEmpty()) {
            String json = gson.toJson(orderFields); // convert hashmaps to json format
            params.put("req_cf_data", json);
        }

        try {
            JSONArray carts = new JSONArray();

            for (Cart c : mCart) {

                JSONObject cart = new JSONObject();
                cart.put("module", c.getModule());
                cart.put("module_id", c.getModule_id());
                cart.put("qty", c.getQte());
                cart.put("amount", c.getAmount() > 0 ? c.getAmount() : 0);

                if (c.getVariants() != null && c.getVariants().size() > 0) {
                    List<Variant> variants = c.getVariants();
                    JSONObject variantsParser = new JSONObject();
                    for (Variant var : variants) {
                        JSONObject optJson = new JSONObject();
                        for (Option opt : var.getOptions()) {
                            optJson.put(opt.getLabel(), String.valueOf(opt.getValue()));
                        }
                        variantsParser.put(var.getGroup_label(), optJson);
                    }

                    cart.put("variants", variantsParser.toString());

                }
                carts.put(cart);
            }
            params.put("cart", carts.toString());


        } catch (JSONException e) {
            e.printStackTrace();
        }

        //send these params only when payment is enabled
        if (SettingsController.isModuleEnabled(Constances.ModulesConfig.ORDER_PAYMENT_MODULE) && mDefaultItemConfig.getProduct_value() > 0 && mDefaultItemConfig.getProduct_type().equalsIgnoreCase("Price")) {
            params.put("user_token", SessionsController.getSession().getToken());
            params.put("payment_method", String.valueOf(PaymentFragment.paymentChoosed));
        }

        if(ConfirmationFragment.mConfirmationCartAppliedDiscount.length() > 0){
            params.put("couponCode",ConfirmationFragment.mAppliedDiscountedCode);
        }

        ApiRequest.newPostInstance(Constances.API.API_ORDERS_CREATE, new ApiRequestListeners() {
            @Override
            public void onSuccess(Parser parser) {

                if(parser.getSuccess() == 0){
                    NSToast.show(getString(R.string.error_try_later));
                    finish();
                    return;
                }

                if(parser.getSuccess() == -1){
                    MessageDialog.showMessage(OrderCheckoutActivity.this, parser.getErrors(), new View.OnClickListener() {
                        @Override
                        public void onClick(View v) {
                            MessageDialog.getInstance().hide();
                            finish();
                        }
                    });
                    (findViewById(R.id.lyt_next)).setEnabled(false);
                    return;
                }

                try {
                    order_id = parser.json.getInt("result");
                } catch (JSONException e) {
                    e.printStackTrace();
                    NSToast.show(getString(R.string.error_try_later));
                    (findViewById(R.id.lyt_next)).setEnabled(false);
                    return;
                }
                
                if(order_id == 0){
                    NSToast.show(getString(R.string.error_try_later));
                    (findViewById(R.id.lyt_next)).setEnabled(false);
                    return;
                }

                if (!SettingsController.isModuleEnabled(Constances.ModulesConfig.ORDER_PAYMENT_MODULE) || mDefaultItemConfig.getProduct_value() == 0 || mDefaultItemConfig.getProduct_type().equalsIgnoreCase("Percent")) {
                    showSuccessPage();
                } else {
                    navigateToPaymentFragment();
                }

                //Save custom field in shared pref
                if (orderFields != null && !orderFields.isEmpty()) {
                    int userId = SessionsController.getSession().getUser().getId();
                    int cfId = mDefaultItemConfig.getCf_id();
                    final SharedPreferences sharedPref = AppController.getInstance()
                            .getSharedPreferences("savedCF_" + cfId + "_" + userId, Context.MODE_PRIVATE);
                    SharedPreferences.Editor editor = sharedPref.edit();
                    editor.putInt("user_id", userId);
                    editor.putInt("req_cf_id", mDefaultItemConfig.getCf_id());
                    editor.putString("cf", gson.toJson(orderFields));
                    editor.commit();
                }

            }

            @Override
            public void onFail(Map<String, String> errors) {
                MessageDialog.showMessage(OrderCheckoutActivity.this, errors, new View.OnClickListener() {
                    @Override
                    public void onClick(View v) {
                        MessageDialog.getInstance().hide();
                        finish();
                    }
                });
            }
        }, params);

    }


    private void generatePaymentLinkAPi(View v) {

        //disable click
        v.setEnabled(false);
        v.setClickable(false);


        final Map<String, String> parameters = new HashMap<String, String>();

        if (SessionsController.isLogged()) {
            parameters.put("user_id", String.valueOf(SessionsController.getSession().getUser().getId()));
            parameters.put("user_token", String.valueOf(SessionsController.getSession().getToken()));
        }


        parameters.put("order_id", String.valueOf(order_id));
        parameters.put("payment", String.valueOf(PaymentFragment.paymentChoosed));

        Log.e("generatePaymentLinkAPi",parameters.toString());


        ApiRequest.newPostInstance(Constances.API.API_PAYMENT_LINK, new ApiRequestListeners() {
            @Override
            public void onSuccess(Parser parser) {

                try {

                    String payment_link = parser.json.getString("result");
                    if (payment_link != null) {
                        displayPaymentWebView(payment_link);
                    } else {
                        NSToast.show(getString(R.string.error_try_later));
                        return;
                    }

                    //enable  button
                    new Handler().postDelayed(new Runnable() {
                        @Override
                        public void run() {
                            v.setEnabled(true);
                            v.setClickable(true);
                        }
                    }, 3500);

                } catch (JSONException e) {
                    e.printStackTrace();
                }

            }

            @Override
            public void onFail(Map<String, String> errors) {

            }
        }, parameters);


    }


    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);

        if (requestCode == PAYMENT_CALLBACK_CODE) {
            if (resultCode == AutocompleteActivity.RESULT_OK) {


                showSuccessPage();
            } else {
                NSToast.show(getString(R.string.payment_error));

            }
        }
    }
}

