<?php
/**
 * Created by PhpStorm.
 * User: amine
 * Date: 12/28/18
 * Time: 22:28
 */

class ImageManagerUtils{


    const IMAGE_SIZE_200 = "200_200";
    const IMAGE_SIZE_560 = "560_560";
    const IMAGE_SIZE_100 = "100_100";
    const IMAGE_FULL_SIZE = "full";

    public static function getImage($dir,$size=self::IMAGE_SIZE_200){

        $images = _openDir($dir);
        if(isset($images[$size]['url'])){
            return $images[$size]['url'];
        }

        return "";
    }

    public static function getFirstImage($images,$size=self::IMAGE_SIZE_200){

        if(is_string($images))
            $images  = json_decode($images,JSON_OBJECT_AS_ARRAY);

        if(isset($images[0]) && is_string($images[0])){
            $images = _openDir($images[0]);
            if(isset($images[$size]['url'])){
                return $images[$size]['url'];
            }
        }else if(isset($images[0]) && is_array($images[0])){
            $images = $images[0];
            if(isset($images[$size]['url'])){
                return $images[$size]['url'];
            }
        }

        return NULL;
    }


    public static function checkAndClearImages(){

        $context = &get_instance();




    }

    public static function imageHTML($images){
        if (isset($images['200_200']['url'])) {
            return '<img src="' . $images['200_200']['url'] . '"width="100%" alt="Product Image">';
        } else {
            return '<img src="' . adminAssets("images/def_logo.png") . '"width="100%"  alt="Product Image">';
        }
    }

    public static function getValidImages($userImageStr){

        if($userImageStr=="")
            return array();

        //convert from image ID or json to the array
        if (!is_array($userImageStr) and !preg_match('#^([0-9]+)$#',$userImageStr)) {
            $userImage = json_decode($userImageStr, JSON_OBJECT_AS_ARRAY);
        }else if(!is_array($userImageStr) and preg_match('#^([0-9]+)$#',$userImageStr)) {
            $userImage = array($userImageStr);
        }



        $array = array();

        if(isset($userImage)){
            foreach ($userImage as $dirName){

                $userImage = _openDir($dirName);

                if(!empty($userImage))
                    $array[] = $userImage;

            }
        }else{
            $array = $userImageStr;
        }

        //validate all images

        $new_arrays = array();

        foreach ($array as $key => $img){
            if(empty($img))
                unset($array[$key]);
            else
                $new_arrays[] = $img;
        }

        return $new_arrays;
    }


    public static function unused_images($new,$old){
        $ctx = &get_instance();
        $ctx->uploader_model->images_to_clear($new,$old);
    }

    public static function validate($image,$manager="unknown"){
        $ctx = &get_instance();
        $ctx->uploader_model->validate($image,$manager);
    }

    public static function checkRequestValidity($key){

        $ctx = &get_instance();

        $errors = array();

        if(!preg_match('#^([a-zA-Z]+)$#i',  ($key!=null?$key:"")    )){
            $errors['error'] = Translate::sprint('Invalidate Upload Function');
        }else{
            $limit = $ctx->uploader->getUploaderSession($key);
            $limit_saved = $ctx->uploader->getUploaderSession('saved-'.$key);
            if($limit==$limit_saved){
                $errors[] = Translate::sprint("You have exceeded the maximum number of files");
            }
        }

        return $errors;

    }

    public static function increaseRequest($key,$id){

        $ctx = &get_instance();

        $errors = array();

        if(!preg_match('#^([a-zA-Z]+)$#i',  ($key!=null?$key:"")    )){
            $errors['error'] = Translate::sprint('Invalidate Upload Function');
        }else{
            $limit = $ctx->uploader->getUploaderSession($key);
            $limit_saved = $ctx->uploader->getUploaderSession('saved-'.$key);
            if($limit==$limit_saved){
                $errors[] = Translate::sprint("You have exceeded the maximum number of files");
            }
        }

        if(!empty($errors))
            return $errors;

        $limit_saved++;
        $ctx->uploader->setUploaderSession('saved-'.$key,$limit_saved);

        $list = $ctx->uploader->getUploaderSession('loaded-images'.$key);
        $list[] = $id;

        $ctx->uploader->setUploaderSession('loaded-images'.$key,$list);

        return TRUE;
    }

}




interface UploaderInterface{
    public function onClearFolder();
}
