<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

class Api extends API_Controller  {


    public function __construct()
    {
        parent::__construct();


    }

    public function get_payment_link()
    {

        $payment_method = RequestInput::post('payment');

        //order to invoice
        $order_id = RequestInput::post('order_id');
        $user_id = RequestInput::post('user_id');
        $user_token = RequestInput::post('user_token');



        $result = $this->mOrderPayment->convert_order_to_invoice($user_id,$order_id);


        if($result[Tags::SUCCESS]==1 && $result[Tags::RESULT]>0){

            if(TokenSetting::isValid($user_id,"logged",$user_token)){

                $token = TokenSetting::getValid($user_id,"logged",$user_token);
                if($token!=NULL){
                    $this->mUserBrowser->refreshData($token->uid);
                }
            }

            //process_payment
            $payment_link = site_url("payment/process_payment?invoiceid=".$result[Tags::RESULT]."&mp=".$payment_method);
            $result[Tags::RESULT] = $payment_link;

        }else{
            $result[Tags::RESULT] = "";
            $result[Tags::SUCCESS] = 0;
        }

        echo json_encode($result);

    }



    public function getPayments(){

        $logged_user_id = $this->requireAuth();
        $payments = PaymentsProvider::getPayments("order_payment");

        foreach ($payments as $k => $payment){

            if($payment['id'] == PaymentsProvider::WALLET_ID){
                $balance = $this->mWalletModel->getBalance($logged_user_id);
                $payments[$k]['description'] = Translate::sprintf("Pay using your balance: %s ",array(Currency::parseCurrencyFormat($balance,DEFAULT_CURRENCY)));
            }

            if($payment['id'] == PaymentsProvider::APPLE_PAY){
                if (defined('DEFAULT_TAX') AND DEFAULT_TAX > 0) {
                    $payments[$k]['taxes'] =  $this->mTaxModel->getTax(DEFAULT_TAX);
                } elseif (defined('DEFAULT_TAX') AND DEFAULT_TAX == -2) {
                    $payments[$k]['taxes']  = json_decode(ConfigManager::getValue("MULTI_TAXES"), JSON_OBJECT_AS_ARRAY);
                }
            }
        }

        echo json_encode(array(Tags::SUCCESS=>1,Tags::RESULT=>$payments),JSON_FORCE_OBJECT);return;

   }

}