<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Created by Console.
 * User: Droideve Technology
 * Date: {date}
 * Time: {time}
 */

class Admin extends ADMIN_Controller {

    public function __construct(){
        parent::__construct();

        ModulesChecker::requireEnabled("offer");
        $this->load->helper('url');
    }

	public function index()
	{

	}


    public function view(){

        if (!GroupAccess::isGranted('offer',MANAGE_OFFERS))
            redirect("error?page=permission");

        $data = array();


        $params = array(
            "offer_id"  => intval(RequestInput::get("id")),
            "limit"     => 1
        );

        $data['offer'] = $this->mOfferModel->getOffers($params);

        if (isset($data['offer'][Tags::RESULT]) and count($data['offer'][Tags::RESULT]) == 1) {
            $this->load->view(AdminPanel::TemplatePath."/include/header", $data);
            $this->load->view("offer/backend/html/edit");
            $this->load->view(AdminPanel::TemplatePath."/include/footer");
        }


    }

    public function edit(){

        if (!GroupAccess::isGranted('offer',EDIT_OFFER))
            redirect("error?page=permission");

        $data = array();

        $data["myStores"] = $this->mStoreModel->getMyAllStores(array(
            "user_id" => $this->mUserBrowser->getData("id_user")
        ));

        $params = array(
            "offer_id"  => intval(RequestInput::get("id")),
            "limit"     => 1,
            "user_id" => SessionManager::getData('id_user')
        );

        $data['offer'] = $this->mOfferModel->getOffers($params);

        $data['cf_list'] = $this->mCFManager->getList(
            SessionManager::getData("id_user")
        );


        if (isset($data['offer'][Tags::RESULT]) and count($data['offer'][Tags::RESULT]) == 1) {
            $this->load->view(AdminPanel::TemplatePath."/include/header", $data);
            $this->load->view("offer/backend/html/edit");
            $this->load->view(AdminPanel::TemplatePath."/include/footer");
        }


    }

    public function all_offers(){


        if (!GroupAccess::isGranted('offer',MANAGE_OFFERS)  )
            redirect("error?page=permission");


        $data = array();

        $params =array(
            "offer_id" => RequestInput::get("offer_id"),
            "store_id" => RequestInput::get("store_id"),
            "date_end" => RequestInput::get("date_end"),
            "page" => RequestInput::get("page"),
            "search" => RequestInput::get("search"),
            "limit"     => NO_OF_ITEMS_PER_PAGE,
            "is_super"     => TRUE,
            "status"     => RequestInput::get("status"), // filter offer by status
            "filterBy"     => RequestInput::get("filterBy"),
        );

        $data['offers'] = $this->mOfferModel->getOffers($params);
        $data['list_title'] = "All offers";

        $this->load->view(AdminPanel::TemplatePath."/include/header",$data);
        $this->load->view("offer/backend/html/offers");
        $this->load->view(AdminPanel::TemplatePath."/include/footer");


    }

    public function my_offers(){


        if (!GroupAccess::isGranted('user')  )
            redirect("error?page=permission");

        $data = array();

        $params =array(
            "offer_id" => RequestInput::get("offer_id"),
            "store_id" => RequestInput::get("store_id"),
            "date_end" => RequestInput::get("date_end"),
            "page"      => RequestInput::get("page"),
            "search" => RequestInput::get("search"),
            "limit"     => NO_OF_ITEMS_PER_PAGE,
            "user_id"     => SessionManager::getData('id_user'),
            "status"     => RequestInput::get("status"), // filter offer by status
            "filterBy"     => RequestInput::get("filterBy"),
        );

        $data['offers'] = $this->mOfferModel->getOffers($params);
        $data['list_title'] = "My offers";

        $this->load->view(AdminPanel::TemplatePath."/include/header",$data);
        $this->load->view("offer/backend/html/offers");
        $this->load->view(AdminPanel::TemplatePath."/include/footer");


    }

    public function add(){

        if (!GroupAccess::isGranted('offer',ADD_OFFER))
            redirect("error?page=permission");

        $data["myStores"] = $this->mStoreModel->getMyAllStores(array(
            "user_id"   => $this->mUserBrowser->getData("id_user")
        ));

        $data['cf_list'] = $this->mCFManager->getList(
            SessionManager::getData("id_user")
        );

        $this->load->view(AdminPanel::TemplatePath."/include/header",$data);
        $this->load->view("offer/backend/html/add");
        $this->load->view(AdminPanel::TemplatePath."/include/footer");

    }




}

/* End of file OfferDB.php */