<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Nstranslator extends MAIN_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->init('nstranslator');
    }


    //overrid
    public function onLoad()
    {

        define("TRANSLATOR_MANAGE",'manage_translation');

        $this->load->helper('translator');
        $this->load->helper('fields_translator');
        $this->load->model('nstranslator/nstranslator_model','mTranslatorModel');

    }

    public function onCommitted($isEnabled)
    {
        if(!$isEnabled)
            return;


        AdminTemplateManager::registerMenuSetting(
            'nstranslator',
            "nstranslator/menu_setting",
            12
        );

        Translate::init();

        //show dropdown list in header
        CMS_Display::set("language_dropdown_v1","nstranslator/plug/header/list",NULL);


    }

    public function onEnable()
    {
        GroupAccess::registerActions('nstranslator',array(
            TRANSLATOR_MANAGE
        ));
    }

    public function onInstall()
    {
        parent::onInstall(); // TODO: Change the autogenerated stub
        $this->mTranslatorModel->createTable();
        return TRUE;
    }

    public function onUpgrade()
    {
        parent::onUpgrade(); // TODO: Change the autogenerated stub

        GroupAccess::registerActions('nstranslator',array(
            TRANSLATOR_MANAGE
        ));

        $this->mTranslatorModel->createTable();

        return TRUE;
    }

}