<!--  Model popup : begin-->
<div class="modal fade" id="modal-default-filter">
    <div class="modal-dialog">
        <form action="<?=current_url()?>" method="get" id="form-orders-filter">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal"
                            aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title"><?= Translate::sprint("Filter orders") ?> </h4>
                </div>
                <div class="modal-body">

                    <div class="row">
                        <div class="col-md-12">

                            <div class="form-group">
                                <label><?= _lang("Product") ?></label>
                                <input type="text" class="form-control" name="product"
                                       placeholder="<?= _lang('Product name') ?>"
                                       value="<?=RequestInput::get('product')?>"/>
                            </div>

                            <div class="form-group">
                                <label><?= _lang("Client name") ?></label>
                                <input type="text" class="form-control" name="client_name"
                                       placeholder="<?= _lang('Client name') ?>"
                                       value="<?=RequestInput::get('client_name')?>"/>
                            </div>


                            <?php if ( $this->uri->segment(3)=="all_orders" && GroupAccess::isGranted('nsorder', MANAGE_ORDER_CONFIG_ADMIN)): ?>
                                <div class="form-group">
                                    <label><?= _lang("Business Owner") ?></label>
                                    <select id="select_owner" data-name="select_owner" class="form-control select2" multiple>
                                    </select>
                                </div>
                                <input type="hidden" name="select_owner" value="<?=RequestInput::get('select_owner')?>">
                            <?php endif; ?>



                            <?php $status = $this->mOrder->getList(); ?>
                            <div class="form-group">
                                <label><?= _lang("Select date") ?></label>
                                <div class="row">
                                    <div class="col-sm-6">
                                        <input type="text" class="form-control datepicker" name="date_start"
                                               placeholder="<?= _lang('Date start') ?>"
                                               value="<?=RequestInput::get('date_start')?>"/>
                                    </div>
                                    <div class="col-sm-6">
                                        <input type="text" class="form-control datepicker" name="date_end"
                                               placeholder="<?= _lang('Date end') ?>"
                                               value="<?=RequestInput::get('date_end')?>"/>
                                    </div>
                                </div>

                            </div>
                            <div class="form-group">
                                <label><?= _lang("Order Status") ?></label>
                                <?php
                                $sc = parseUrlParam('select_order_status');
                                ?>
                                <select id="select_order_status"  class="form-control select2" data-name="select_order_status" multiple>
                                    <?php foreach ($status as $s): ?>
                                        <option value="<?= $s['id'] ?>"  <?=in_array($s['id'],$sc)?"selected":""?>><?= $s['label'] ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <input type="hidden" name="select_order_status" value="">
                            </div>

                            <div class="form-group">
                                <label><?= _lang("Payment Status") ?></label>

                                <?php
                                $sc = parseUrlParam('select_payment_status');
                                ?>

                                <select id="select_payment_status" data-name="select_payment_status" multiple class="form-control select2">
                                    <?php foreach (Order_payment::PAYMENT_STATUS as $k => $ps): ?>
                                        <option value="<?= $k ?>"  <?=in_array($k,$sc)?"selected":""?> ><?= _lang($ps['label']) ?></option>
                                    <?php endforeach; ?>
                                </select>
                                <input type="hidden" name="select_payment_status" value="">
                            </div>
                            <div class="form-group">
                                <label><?= _lang("Limit") ?></label>
                                <select class="select2 form-control" name="limit" id="limit">
                                    <option value="30" <?=RequestInput::get('limit')==30?"selected":""?>>30</option>
                                    <option value="60" <?=RequestInput::get('limit')==60?"selected":""?>>60</option>
                                    <option value="100" <?=RequestInput::get('limit')==100?"selected":""?>>100</option>
                                    <option value="200" <?=RequestInput::get('limit')==200?"selected":""?>>200</option>
                                    <option value="300" <?=RequestInput::get('limit')==300?"selected":""?>>300</option>
                                    <option value="500" <?=RequestInput::get('limit')==500?"selected":""?>>500</option>
                                    <option value="700" <?=RequestInput::get('limit')==700?"selected":""?>>700</option>
                                    <option value="1000 <?=RequestInput::get('limit')==1000?"selected":""?>">1000</option>
                                </select>
                            </div>
                        </div>
                    </div>


                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default pull-left"
                            data-dismiss="modal"><?= Translate::sprint("Cancel") ?></button>
                    <button type="button" id="_filter"
                            data=""
                            class="btn btn-flat btn-primary"><?= Translate::sprint("Apply") ?></button>
                </div>
            </div>

        </form>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!--  Model popup : end-->

