<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Nsorder extends MAIN_Controller
{

    const MODULE_NAME = "nsorder";

    public function __construct()
    {
        parent::__construct();
        $this->init('nsorder');
    }

    public function onLoad()
    {
        $this->load->model("nsorder/nsorder_model","mOrder");
        $this->load->helper("nsorder/order");

        define('MANAGE_ORDERS','manage_orders');
        define('MANAGE_ORDER_STATUS_LIST_ADMIN','manage_order_status');
        define('MANAGE_ORDER_CONFIG_ADMIN','manage_order_config');

    }


    public function onCommitted($isEnabled)
    {
        if(!$isEnabled)
            return;

        AdminTemplateManager::registerMenu(
            self::MODULE_NAME,
            "nsorder/menu",
            3
        );


        if(ModulesChecker::whenIsActive("cms")
            && $this->mUserBrowser->isLogged()){



            $myData['chart_v1_home'] = SimpleChart::get('chart_v1_home');

            if(!empty($myData['chart_v1_home'])){

                if(GroupAccess::isGranted('nsorder',MANAGE_ORDER_CONFIG_ADMIN)){
                    $data['result'] =  $this->mOrder->getOrdersAnalyticsToday();
                    $data['result_this_month'] =  $this->mOrder->getOrdersSalesThisMonth();
                    $data['result_today'] =  $this->mOrder->getOrdersSalesToday();
                    $data['result_this_year'] =  $this->mOrder->getOrdersSalesYear();
                }else{
                    $data['result'] =  $this->mOrder->getOrdersAnalyticsToday($this->mUserBrowser->getData('id_user'));
                    $data['result_this_month'] =  $this->mOrder->getOrdersSalesThisMonth($this->mUserBrowser->getData('id_user'));
                    $data['result_today'] =  $this->mOrder->getOrdersSalesToday($this->mUserBrowser->getData('id_user'));
                    $data['result_this_year'] =  $this->mOrder->getOrdersSalesYear($this->mUserBrowser->getData('id_user'));
                }

                CMS_Display::replace("widget_middle","nsorder/backend/charts/charts_v1",$data);

            }



        }


        if(ModulesChecker::isEnabled("digital_wallet")){

            ActionsManager::register("nsorder","orderDelivered",function ($args){

                //get Deloivered order
                $order = $this->mOrder->getTotalOrder(intval($args));

                //release platform commission
                $bo_commission = $order['bo_commission'];

                //get store user
                $store = $this->mOrder->getStoreFromCart($args);

                //send Order payment to Business owner
                $orderID = "#" . str_pad($args, 6, 0, STR_PAD_LEFT) ;
                $result = $this->mWalletModel->sendMoneyAdminByID($store['user_id'],$order['sub_total'],"Order payment ".$orderID);

                if($result[Tags::SUCCESS]==1){

                }
            });
        }

    }


    public function onEnable()
    {

        GroupAccess::registerActions(Nsorder::MODULE_NAME,array(
            MANAGE_ORDERS,
            MANAGE_ORDER_STATUS_LIST_ADMIN,
            MANAGE_ORDER_CONFIG_ADMIN
        ));

        $this->mOrder->create_attach_default_cf();
        $this->mOrder->init_order_status();

        return TRUE;
    }

    public function onUpgrade()
    {
        parent::onUpgrade(); // TODO: Change the autogenerated stub

        $this->mOrder->createTables();
        $this->mOrder->updateFields();
        $this->mOrder->createPayoutsTable();
        $this->mOrder->createCartOrderTable();
        $this->mOrder->emigration();


        ConfigManager::setValue("ORDER_COMMISSION_ENABLED",TRUE,TRUE);
        ConfigManager::setValue("ORDER_COMMISSION_VALUE",10,TRUE);

        return TRUE;
    }


    public function onInstall()
    {
        parent::onInstall(); // TODO: Change the autogenerated stub

        $this->mOrder->createTables();
        $this->mOrder->updateFields();
        $this->mOrder->createPayoutsTable();
        $this->mOrder->createCartOrderTable();
        $this->mOrder->emigration();

        ConfigManager::setValue("ORDER_COMMISSION_ENABLED",TRUE,TRUE);
        ConfigManager::setValue("ORDER_COMMISSION_VALUE",10,TRUE);

        return TRUE;
    }


}