<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Created by DT Team.
 * AppName: NearbyStores
 */

class Gallery extends MAIN_Controller {

    public function __construct(){
        parent::__construct();

        $this->init("gallery");
    }

    public function onLoad()
    {

        define('KS_NBR_GALLERY_PER_STORE','nbr_gallery_per_store');
        define('MANAGE_GALLERY','manage_gallery');

        $this->load->model("gallery_model","mGalleryModel");
    }

    //call it after loading all modules
    public function onCommitted($isEnabled)
    {
        parent::onCommitted($isEnabled); // TODO: Change the autogenerated stub

        if(!$isEnabled)
            return;


        AdminTemplateManager::registerMenu(
            'gallery',
            "gallery/menu",
            9
        );


        UserSettingSubscribe::set('gallery',array(
            'field_name' => KS_NBR_GALLERY_PER_STORE,
            'field_type' => UserSettingSubscribeTypes::INT,
            'field_default_value' => 30,
            'config_key' => 'NBR_GALLERY_PER_STORE',
            'field_label' => 'Number gallery allowed per Store',
            'field_comment' => '',
            '_display'      => 0
        ));


    }

    private function registerModuleActions(){

        GroupAccess::registerActions("gallery",array(
            MANAGE_GALLERY,
        ));

    }

    public function onEnable()
    {
        $this->registerModuleActions();
    }

    public function onUninstall()
    {

    }

    public function onInstall()
    {
        $this->mGalleryModel->createTable();
        $this->mGalleryModel->updateFields();

        return TRUE;
    }

    public function onUpgrade()
    {
        $this->mGalleryModel->createTable();
        $this->mGalleryModel->updateFields();

        $this->registerModuleActions();

        return TRUE;
    }


}

/* End of file UploaderDB.php */