<?php



$users = $userResult[Tags::RESULT];


$orders = $ordersResult[Tags::RESULT];
$pagination = $ordersResult[Tags::PAGINATION];

$typeAuth = $this->mUserBrowser->getData("typeAuth");

?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <!-- Message Error -->
            <div class="col-sm-12">
                <?php $this->load->view(AdminPanel::TemplatePath."/include/messages"); ?>
            </div>

        </div>

        <div class="row">
            <div class="col-md-4">
                <div class="box box-widget widget-user">
                    <div class="widget-user-header bg-primary">
                        <h3 class="widget-user-username"><strong><?=$users[0]['name']?></strong></h3>
                        <h5 class="widget-user-desc"><?=_lang("Delivery boy")?></h5>
                    </div>

                    <?php

                    $image = "";

                    if (isset($users[0]['images'][0]['200_200']['url'])) {
                        $image = $users[0]['images'][0]['200_200']['url'];
                    } else {
                        $image = adminAssets("images/profile_placeholder.png");
                    }


                    ?>

                    <div class="img-circle widget-user-image" style="background-image: url('<?= $image ?>');background-size: auto 100%;
                            background-position: center;">
                        <img class="img-circle invisible" src="<?=$image?>" alt="User Avatar">
                    </div>
                    <div class="box-footer">
                        <div class="row">
                            <div class="col-sm-6 border-right">
                                <div class="description-block">
                                    <h5 class="description-header"><?=$this->mDeliveryModel->countDelivered($users[0]['id_user'])?></h5>
                                    <span class="description-text"><?=_lang('Delivered')?></span>
                                </div>
                            </div>
                            <div class="col-sm-6">
                                <div class="description-block">
                                    <h5 class="description-header"><?=Currency::parseCurrencyFormat($this->mDeliveryModel->countDeliveredEarnings($users[0]['id_user']), ConfigManager::getValue('DEFAULT_CURRENCY'))?></h5>
                                    <span class="description-text"><?=_lang('Earnings')?></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="small-box bg-green">
                    <div class="inner">
                        <h3><?=Currency::parseCurrencyFormat($this->mWalletModel->getBalance($users[0]['id_user']), ConfigManager::getValue('PAYMENT_CURRENCY')); ?></h3>
                        <p><?=_lang('Balance')?></p>
                    </div>
                    <div class="icon">
                        <i class="mdi mdi-wallet"></i>
                    </div>
                    <a href="#" class="small-box-footer text-black"  data-toggle="modal" data-target="#Withdraw_money_modal">
                        <?=_lang('Withdraw_money')?> <i class="fa fa-arrow-circle-right"></i>
                    </a>
                </div>
            </div>
            <div class="col-md-8">
                <div class="box box-solid">
                    <div class="box-header">
                        <div class="box-title" style="width : 100%;">
                            <strong><i class="mdi mdi-cube"></i>  <?=_lang("Orders")?></strong>&nbsp;&nbsp;
                        </div>
                    </div>

                    <!-- /.box-header -->
                    <div class="box-body table-responsive">

                        <table id="" class="table table-bordered table-hover">
                            <thead>
                            <tr>
                                <th><?= Translate::sprint("Order ID") ?></th>
                                <th><?= Translate::sprint("Client") ?></th>
                                <th><?= Translate::sprint("Status") ?></th>
                                <th><?= Translate::sprint("Payment") ?></th>
                                <th><?= Translate::sprint("Amount") ?></th>
                                <th><?= Translate::sprint("Date") ?></th>
                            </tr>
                            </thead>
                            <tbody id="list">

                            <?php if (!empty($orders)) : ?>

                                <?php foreach ($orders as $key => $order): ?>


                                <tr>
                                    <td>
                                        <b> <?= "#" . str_pad($order['id'], 6, 0, STR_PAD_LEFT) ?> </b>
                                    </td>
                                    <td>
                                        <?= ucfirst($this->mUserModel->getFieldById("name", $order['user_id'])) ?>
                                    </td>
                                    <td>
                                        <?php
                                        if (isset($order['status']) && $order['status'] != "") {
                                            $statusParser = explode(";", $order['status']);
                                            echo "<span class=badge style='background:" . $statusParser[1] . "'>" . $statusParser[0] . "</span>";
                                        }
                                        ?>
                                    </td>
                                    <td>
                                        <?php
                                        $pcode = $order['payment_status'];
                                        $payments = Order_payment::PAYMENT_STATUS;
                                        if (isset($payments[$pcode])) {
                                            if($pcode=="cod"){
                                                echo "<span class='badge' style='background-color: " . $payments[$pcode]['color'] . "'>" . _lang('Cash on delivery') . "</span>";
                                            }elseif($pcode=="cod_paid"){
                                                echo "<span class='badge' style='background-color: " . $payments[$pcode]['color'] . "'>" . _lang('Paid on delivery') . "</span>";
                                            }else{
                                                echo "<span class='badge' style='background-color: " . $payments[$pcode]['color'] . "'>" . ucfirst(_lang($payments[$pcode]['label'])) . "</span>";
                                            }

                                        }else if($pcode == "cod_paid"){
                                            echo "<span class='badge bg-green'>"._lang("Paid on delivery")."</span>";
                                        }
                                        ?>
                                    </td>
                                    <td>

                                        <?php
                                        $amount = $this->mOrder->getTotalOrder($order['id']);
                                        echo Currency::parseCurrencyFormat($amount['total'],ConfigManager::getValue('DEFAULT_CURRENCY'))
                                        ?>

                                    </td>
                                    <td>
                                        <?=date('Y-d-m',strtotime($order['created_at']))?>
                                    </td>
                                </tr>

                                <?php endforeach; ?>

                            <?php else: ?>
                                <tr>
                                    <td colspan="7" align="center">
                                        <div style="text-align: center"><?= Translate::sprint("No data found", "") ?></div>
                                    </td>
                                </tr>
                            <?php endif; ?>
                            </tbody>
                        </table>

                        <div class="row">
                            <div class="col-sm-12">
                                <div class="dataTables_paginate paging_simple_numbers" id="example2_paginate">
                                    <?php
                                    echo $pagination->links(array(
                                        "status" => intval(RequestInput::get("status")),
                                        "search" => RequestInput::get("search"),
                                        "owner_id" => intval(RequestInput::get("owner_id")),
                                    ), $pagination_url);
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>



                </div>
                <!-- /.box -->
                <!-- /.box -->
            </div>
            <!-- /.col -->
        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->

<?php if (GroupAccess::isGranted('user')): ?>

    <div class="modal fade" id="modal-default">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title"></h4>
                </div>
                <div class="modal-body">

                    <div class="row">

                        <div style="text-align: center">
                            <h3 class="text-red"><?= Translate::sprint("Are you sure?") ?></h3>
                        </div>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" id="_apply"
                            class="btn btn-flat btn-primary pull-right"><?= Translate::sprint("Yes") ?></button>
                    <button type="button" class="btn btn-flat btn-default pull-right"
                            data-dismiss="modal"><?= Translate::sprint("No") ?></button>
                </div>
            </div>

            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>
    <div class="modal fade" id="switcher">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title"></h4>
                </div>
                <div class="modal-body">

                    <div class="callout callout-info">
                        <p> <?= Translate::sprint("You should know that you can sign all stores, events and products to another owner by selecting the owner from the list above") ?></p>
                    </div>

                    <div class="form-group">
                        <label><?= Translate::sprint("Select owner") ?></label>
                        <select id="select_owner" name="select_owner" class="form-control select2">
                            <option selected="" value="0">---- <?= Translate::sprint("Select") ?></option>
                        </select>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-default pull-left"
                            data-dismiss="modal"><?= Translate::sprint("Cancel", "Cancel") ?></button>
                    <button type="button" id="apply"
                            class="btn btn-flat btn-primary"><?= Translate::sprint("Apply and delete") ?></button>
                </div>
            </div>

            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>



    <div class="modal fade" id="Withdraw_money_modal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span></button>
                    <h4 class="modal-title"><?= Translate::sprint("Withdraw money") ?></h4>
                </div>
                <div class="modal-body">
                    <div class="form-group">
                        <label><?= _lang("Amount to be withdrawn") ?></label>
                        <input max="<?=$this->mWalletModel->getBalance($users[0]['id_user'])?>" class="form-control" name="amount" id="amount" value="<?=$this->mWalletModel->getBalance($users[0]['id_user'])?>" type="number" placeholder="<?=_lang('Enter amount')?>" />
                        <input type="hidden" id="user_id" value="<?=$users[0]['id_user']?>"/>
                    </div>

                    <div class="form-group">
                        <label><?= _lang("To bank") ?></label>
                        <select class="form-control" id="bank">
                            <?php foreach (Wallet_helper::getBanks($users[0]['id_user']) as $bank): ?>
                                <option value="<?=$bank['id']?>"><?=$bank['name']?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>

                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal"
                            class="btn btn-flat btn-default pull-left"><?= Translate::sprint("Cancel") ?></button>
                    <button type="button" id="WithdrawBtn"
                            class="btn btn-flat btn-primary pull-right"><?= Translate::sprint("Withdraw") ?></button>
                </div>
            </div>

            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <?php

    $script = $this->load->view('delivery/backend/scripts/delivery-script', NULL, TRUE);
    AdminTemplateManager::addScript($script);

    ?>


<?php endif; ?>



