<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Created by Console.
 * User: Droideve Technology
 * Date: {date}
 * Time: {time}
 */

class Delivery extends MAIN_Controller {

    private $module = "delivery";

    public function __construct(){
        parent::__construct();
        $this->init($this->module);

    }

    public function onLoad()
    {

        $this->load->model('delivery/delivery_model','mDeliveryModel');
        $this->load->model('nsorder/nsorder_model','mOrderModel');
        $this->load->helper('delivery/delivery');


        define('MANAGE_DELIVERY_USERS','manager_delivery_users');
        define('MANAGE_DELIVERY_PAYOUTS','manage_delivery_payouts');
        define('MANAGE_DELIVERY_ASSIGNMENT','delivery_assignment');
        define('MANAGE_DELIVERY_ORDERS','deliver_orders');

        define('KS_DELIVERY_ENABLED','delivery_enabled');


    }

    public function onCommitted($isEnabled)
    {

        if(!$isEnabled)
            return;

        AdminTemplateManager::registerMenu(
            'delivery',
            "delivery/menu",
            4
        );

        $this->register_modules();

        @$this->init_delivery_checkout();


        ActionsManager::register('order_payment','payment_invoice_generated',function ($invoice){
           $this->mDeliveryModel->calculate_commission($invoice);
        });

        //setup Counter delivery
        if(ModulesChecker::whenIsActive("cms") && $this->mUserBrowser->isLogged()){

            $this->load->helper('cms/charts');
            SimpleChart::add('delivery','chart_v1_home',function ($months){

                if(GroupAccess::isGranted('delivery')){
                    return $this->mDeliveryModel->getOrdersToBeDelivered();
                }else{
                    return $this->mDeliveryModel->getOrdersToBeDelivered($this->mUserBrowser->getData('id_user'));
                }

            });

        }

        //disable subscription for delivery men
        $this->mDeliveryModel->disable_subscription();

        ConfigManager::setValue("DELIVERY_ANDROID_LINK","",TRUE);
        ConfigManager::setValue("DELIVERY_IOS_LINK","",TRUE);
        ConfigManager::setValue("DELIVERY_FEES_COMMISSION_VALUE",100,TRUE);
        ConfigManager::setValue("DELIVERY_PAYOUT_PERIOD","digital_wallet",TRUE);

        //Setup User Config
        UserSettingSubscribe::set('delivery',array(
            'field_name' => KS_DELIVERY_ENABLED,
            'field_type' => UserSettingSubscribeTypes::BOOLEAN,
            'field_default_value' => true,
            'config_key' => 'DELIVERY_ENABLED',
            'field_label' => 'Delivery',
            'field_comment' => '',
            '_display' => 1
        ));

        $grp = $this->mDeliveryModel->getGrp();

        if(!empty($grp)
            && SessionManager::isLogged()
            && SessionManager::getData("grp_access_id")==$grp->id){
            CMS_Display::replaceHTML("subscription_status_v1", "", NULL);
        }

        ActionsManager::register("store","func_getStores",function ($list){
            foreach ($list as $key => $value){
                if(UserSettingSubscribe::getUDBSetting($value['user_id'],KS_DELIVERY_ENABLED) != 1){
                    $list[$key]['delivery'] = 0;
                }
            }
            return $list;
        });


    }


    public function getSubscriptionParameters($userId){
        $parameters = [];
        $fields = UserSettingSubscribe::load();
        foreach ($fields as $field) {
            $field_name = $field['field_name'];
            $value = UserSettingSubscribe::getUDBSetting($userId, $field_name);
            $parameters[$userId."_:_".$field['field_name']] = $value;
        }
        return $parameters;
    }


    private function init_delivery_checkout(){

        $pdc_cf_id = intval(ConfigManager::getValue("product_default_checkout_cf"));

        if($pdc_cf_id == 0){
            $pdc_cf_id = $this->mDeliveryModel->create_default_checkout_fields();
            if($pdc_cf_id>0){
                ConfigManager::setValue("product_default_checkout_cf",intval($pdc_cf_id));
            }
        }

    }

    private function register_modules(){

    }

    public function cron(){

        $this->mDeliveryModel->manage_payout();
    }

    public function onEnable()
    {
        $this->mDeliveryModel->create_report_status();
        $this->mDeliveryModel->generate_db_grp();

        ConfigManager::setValue("DELIVERY_FEES_TYPE","disabled",TRUE);
        ConfigManager::setValue("DELIVERY_FEES_VALUE",0,TRUE);


        GroupAccess::registerActions("delivery",array(
            MANAGE_DELIVERY_USERS,
            MANAGE_DELIVERY_PAYOUTS,
            MANAGE_DELIVERY_ASSIGNMENT,
            MANAGE_DELIVERY_ORDERS,
        ));

        return parent::onEnable(); // TODO: Change the autogenerated stub
    }

    public function onInstall()
    {

        $this->mDeliveryModel->createTables();
        $this->mDeliveryModel->updateFields();
        $this->mDeliveryModel->update_products_cf();

        return TRUE;
    }

    public function onUpgrade()
    {


        $this->mDeliveryModel->createTables();
        $this->mDeliveryModel->updateFields();
        $this->mDeliveryModel->create_report_status();
        $this->mDeliveryModel->update_products_cf();


        GroupAccess::reloadActions("delivery",array(
            MANAGE_DELIVERY_USERS,
            MANAGE_DELIVERY_PAYOUTS,
            MANAGE_DELIVERY_ASSIGNMENT,
            MANAGE_DELIVERY_ORDERS,
        ));

        return TRUE;
    }


}

/* End of file UploaderDB.php */