<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Created by Console.
 * User: Droideve Technology
 * Date: {date}
 * Time: {time}
 */

class Ajax extends AJAX_Controller {

    public function __construct(){
        parent::__construct();
        //load model
    }


    public function requestWithdrawal(){

        $user_id = intval(RequestInput::post('user_id'));
        $amount = doubleval(RequestInput::post('amount'));
        $bank = doubleval(RequestInput::post('bank'));

        $result = $this->mDeliveryModel->requestWithdrawalFromWallet($user_id,$bank,$amount,"delivery");
        echo json_encode($result);
    }

    public function orderAssignTo(){

        if(!GroupAccess::isGranted('nsorder',MANAGE_ORDERS)){
            echo json_encode(array(Tags::SUCCESS=>0,Tags::ERRORS=>array(
                "error"  => Translate::sprint(Messages::PERMISSION_LIMITED)
            )));
            exit();
        }


        $this->mDeliveryModel->orderAssign(
            RequestInput::post("order_id"),
            RequestInput::post("delivery_id"),
        );

        echo json_encode(array(Tags::SUCCESS=>1));return;
    }

    public function getDelivery()
    {

        if(!GroupAccess::isGranted('user')){
            echo json_encode(array(Tags::SUCCESS=>0,Tags::ERRORS=>array(
                "error"  => Translate::sprint(Messages::PERMISSION_LIMITED)
            )));
            exit();
        }

        $params = array(
            "page" => RequestInput::get("page"),
            "id" => RequestInput::get("id"),
            "search" => RequestInput::get("search"),
            "limit" => -1,
            "is_super" => TRUE,
            "user_id" => $this->mUserBrowser->getData("id_user")
        );

        $grp = $this->mDeliveryModel->getGrp();
        $params['grp_acc_id'] = $grp->id;
        $params['is_super'] = TRUE;

        $result = $this->mUserModel->getUsers($params,function ($params){
            $this->db->where('user.grp_access_id',$params['grp_acc_id']);
        });

        $json = array();
        foreach ($result[Tags::RESULT] as $obj) {
            $json[] = array(
                "text" => $obj['name'] . ", @" . $obj['username'] , "id" => $obj['id_user'],
            );
        }

        echo json_encode($json);
    }



    public function accept(){

        if(!GroupAccess::isGranted('user',MANAGE_USERS)){
            echo json_encode(array(Tags::SUCCESS=>0,Tags::ERRORS=>array(
                "error"  => Translate::sprint(Messages::PERMISSION_LIMITED)
            )));
            exit();
        }

        $id = intval(RequestInput::get('id'));
        $this->mDeliveryModel->update_delivery_user_status($id,1);

        echo json_encode(array(Tags::SUCCESS=>1));return;
    }

    public function decline(){

        if(!GroupAccess::isGranted('user',MANAGE_USERS)){
            echo json_encode(array(Tags::SUCCESS=>0,Tags::ERRORS=>array(
                "error"  => Translate::sprint(Messages::PERMISSION_LIMITED)
            )));
            exit();
        }

        $id = intval(RequestInput::get('id'));
        $this->mDeliveryModel->update_delivery_user_status($id,-1);

        echo json_encode(array(Tags::SUCCESS=>1));return;
    }

    public function set_pid(){


        $id = RequestInput::post("pid");

        if($id != ""){
            ConfigManager::setValue("DELIVERY_MODULE_PID",$id);
            echo json_encode(array(Tags::SUCCESS=>1));return;
        }

        echo json_encode(array(Tags::SUCCESS=>0));return;
    }

    public function saveDFeesConfig(){

        $this->enableDemoMode();

        if(!GroupAccess::isGranted('nsorder',MANAGE_ORDER_CONFIG_ADMIN)){
            echo json_encode(array(Tags::SUCCESS=>0,Tags::ERRORS=>array(
                "error"  => Translate::sprint(Messages::PERMISSION_LIMITED)
            )));
            exit();
        }

        $DELIVERY_FEES_TYPE = RequestInput::post("DELIVERY_FEES_TYPE");
        $DELIVERY_FEES_VALUE = RequestInput::post("DELIVERY_FEES_VALUE");
        $DELIVERY_FEES_COMMISSION_VALUE = RequestInput::post("DELIVERY_FEES_COMMISSION_VALUE");

        ConfigManager::setValue("DELIVERY_FEES_TYPE",$DELIVERY_FEES_TYPE);
        ConfigManager::setValue("DELIVERY_FEES_VALUE",$DELIVERY_FEES_VALUE);
        ConfigManager::setValue("DELIVERY_FEES_COMMISSION_VALUE",$DELIVERY_FEES_COMMISSION_VALUE);

        echo json_encode(array(Tags::SUCCESS=>1)); return;

    }

    public function savePayoutConfig(){

        $this->enableDemoMode();

        if(!GroupAccess::isGranted('nsorder',MANAGE_ORDER_CONFIG_ADMIN)){
            echo json_encode(array(Tags::SUCCESS=>0,Tags::ERRORS=>array(
                "error"  => Translate::sprint(Messages::PERMISSION_LIMITED)
            )));
            exit();
        }

        ConfigManager::setValue("DELIVERY_PAYOUT_PERIOD",RequestInput::post("DELIVERY_PAYOUT_PERIOD"));

        echo json_encode(array(Tags::SUCCESS=>1)); return;

    }

    public function saveDBannerConfig(){

        $this->enableDemoMode();

        if(!GroupAccess::isGranted('nsorder',MANAGE_ORDER_CONFIG_ADMIN)){
            echo json_encode(array(Tags::SUCCESS=>0,Tags::ERRORS=>array(
                "error"  => Translate::sprint(Messages::PERMISSION_LIMITED)
            )));
            exit();
        }

        $DELIVERY_IOS_LINK = RequestInput::post("DELIVERY_IOS_LINK");
        $DELIVERY_ANDROID_LINK = RequestInput::post("DELIVERY_ANDROID_LINK");

        ConfigManager::setValue("DELIVERY_IOS_LINK",$DELIVERY_IOS_LINK);
        ConfigManager::setValue("DELIVERY_ANDROID_LINK",$DELIVERY_ANDROID_LINK);

        echo json_encode(array(Tags::SUCCESS=>1)); return;

    }

    public function delete_payout()
    {

        if (!GroupAccess::isGranted('delivery',MANAGE_DELIVERY_PAYOUTS)) {
            echo json_encode(array(Tags::SUCCESS => 0, Tags::ERRORS => array(
                "error" => Translate::sprint(Messages::PERMISSION_LIMITED)
            )));
            exit();
        }

        $this->db->where('id', RequestInput::post('id'));
        $this->db->delete('payouts');

        echo json_encode(array(Tags::SUCCESS=>1));
        return;
    }

    public function edit_payout()
    {

        if (!GroupAccess::isGranted('delivery',MANAGE_DELIVERY_PAYOUTS)) {
            echo json_encode(array(Tags::SUCCESS => 0, Tags::ERRORS => array(
                "error" => Translate::sprint(Messages::PERMISSION_LIMITED)
            )));
            exit();
        }

        $params  = array(
            'id' => RequestInput::post('id'),
            'method' => RequestInput::post('method'),
            'note' => RequestInput::post('note'),
            'user_id' => RequestInput::post('user_id'),
            'currency' => RequestInput::post('currency'),
            'status' => RequestInput::post('status'),
        );


        $payout = $this->mOrder->getPayoutObject(intval(RequestInput::post('id')));


        if($payout['status'] == 'cancel'){
            echo json_encode(array(Tags::SUCCESS=>1,"url"=>admin_url("delivery/payouts")));
            return;
        }

        $result = $this->mOrder->editPayout($params);

        $result['url'] = admin_url("delivery/payouts");

        echo json_encode($result);
        return;
    }


    public function add_payout()
    {

        if (!GroupAccess::isGranted('delivery',MANAGE_DELIVERY_PAYOUTS)) {
            echo json_encode(array(Tags::SUCCESS => 0, Tags::ERRORS => array(
                "error" => Translate::sprint(Messages::PERMISSION_LIMITED)
            )));
            exit();
        }

        $params  = array(
            'method' => RequestInput::post('method'),
            'note' => RequestInput::post('note'),
            'user_id' => RequestInput::post('user_id'),
            'amount' => RequestInput::post('amount'),
            'currency' => RequestInput::post('currency'),
            'status' => RequestInput::post('status'),
            'module' => "delivery",
        );

        $result = $this->mOrder->addPayout($params);


        $result['url'] = admin_url("delivery/payouts");


        echo json_encode($result);
        return;
    }


    public function getDeliveryUsers(){


        if(!GroupAccess::isGranted('delivery',MANAGE_DELIVERY_PAYOUTS)){
            echo json_encode(array(Tags::SUCCESS=>0,Tags::ERRORS=>array(
                "error"  => Translate::sprint(Messages::PERMISSION_LIMITED)
            )));
            exit();
        }

        $params = array(
            'limit' => 5,
            'search' => RequestInput::get("q"),
        );

        $grp = $this->mDeliveryModel->getGrp();
        $params['grp_acc_id'] = $grp->id;
        $params['is_super'] = TRUE;

        $data = $this->mUserModel->getUsers($params,function ($params){
            $this->db->where('grp_access_id',$params['grp_acc_id']);
        });

        $json = array();
        foreach ($data[Tags::RESULT] as $obj) {

            $start = date("Y-m",time())."-01 00:00:00";
            $end = date("Y-m-t",time())." 23:59:59";

            $orders = $this->mDeliveryModel->getOrdersQuery(
                $start,
                $end,
                $obj['id_user']
            );


            $amount = 0;

            foreach ($orders as $order){
                $amount = $order['delivery_commission'] + $amount;
            }

            $json[] = array(
                "text" => $obj['name'] . ", @" . $obj['username']. ", "._lang("Balance").": " . Currency::parseCurrencyFormat($amount, PAYMENT_CURRENCY) ,
                "id" => $obj['id_user'],
                "balance" => $amount,
                "balance_wc" => Currency::parseCurrencyFormat($amount, PAYMENT_CURRENCY)
            );
        }

        echo json_encode($json);
        return;

    }

}

/* End of file UploaderDB.php */