<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');



class Admin extends ADMIN_Controller {

    public function __construct(){
        parent::__construct();
        //load model
    }



    public function delivery_config(){

        if (!GroupAccess::isGranted('setting',CHANGE_APP_SETTING))
            redirect("error?page=permission");


        $data['title'] = _lang("Delivery config");
        $this->load->view(AdminPanel::TemplatePath."/include/header",$data);
        $this->load->view("delivery/backend/delivery-config");
        $this->load->view(AdminPanel::TemplatePath."/include/footer");

    }


    public function addPayout()
    {

        if (!GroupAccess::isGranted('delivery'))
            redirect("error?page=permission");

        $this->load->view(AdminPanel::TemplatePath."/include/header");
        $this->load->view("delivery/backend/payouts/add_payout");
        $this->load->view(AdminPanel::TemplatePath."/include/footer");


    }

    public function payouts(){

        if (!GroupAccess::isGranted('delivery'))
            redirect("error?page=permission");

        $status = RequestInput::get('status');
        if($status=="")  $status = 2;
        else  $status = intval($status);

        $params = array(
            "status"  => $status,
            "page"  => intval(RequestInput::get('page')),
            "payout_id"  => intval(RequestInput::get('id')),
            "transaction_id"  => intval(RequestInput::get('transaction_id')),
            "limit"  => 15,
            "order_by_date"  => 1
        );

        if(!GroupAccess::isGranted('delivery',MANAGE_DELIVERY_PAYOUTS))
            $params['user_id'] = SessionManager::getData('id_user');

        $data['result'] = $this->mOrderModel->getPayout($params,array(
            'module' => 'delivery'
        ));

        $this->load->view(AdminPanel::TemplatePath."/include/header",$data);
        $this->load->view("delivery/backend/payouts/payouts_list");
        $this->load->view(AdminPanel::TemplatePath."/include/footer");


    }



    public function editPayout(){

        if (!GroupAccess::isGranted('delivery',MANAGE_DELIVERY_PAYOUTS))
            redirect("error?page=permission");

        $id = intval(RequestInput::get("id"));

        $p = $this->mOrder->getPayoutObject($id);

        if($p==NULL)
            redirect("error404");

        $data['payout'] = $p;

        $this->load->view(AdminPanel::TemplatePath."/include/header",$data);
        $this->load->view("delivery/backend/payouts/edit_payout");
        $this->load->view(AdminPanel::TemplatePath."/include/footer");

    }


    public function profile(){

        if (!GroupAccess::isGranted('delivery',MANAGE_DELIVERY_PAYOUTS))
            redirect("error?page=permission");

        $params = array(
            "id" => RequestInput::get("id"),
            'limit' => 1,
            "user_id" => $this->mUserBrowser->getData("id_user")
        );


        $grp = $this->mDeliveryModel->getGrp();
        $params['grp_acc_id'] = $grp->id;
        $params['is_super'] = TRUE;

        //get user
        $data['userResult'] = $this->mUserModel->getUsers($params,function ($params){
            $this->db->where('user.grp_access_id',$params['grp_acc_id']);
        },function ($params){
            $this->db->order_by('user.status ASC, user.id_user DESC');
        });


        if(!isset($data['userResult'][Tags::RESULT][0]))
            redirect('error404');


        $limit = RequestInput::get("limit");
        $limit = isset($limit) ? $limit : NO_OF_ITEMS_PER_PAGE;

        $params = array(
            "page" => intval(RequestInput::get("page")),
            "limit" => $limit,
        );

        //get orders list
        $data['ordersResult']= $this->mOrderModel->getOrders($params,array(
            'delivery_id' => $data['userResult'][Tags::RESULT][0]['id_user']
        ));

        $data['pagination_url'] = admin_url("delivery/profile?id=".RequestInput::get("id"));

        $this->load->view(AdminPanel::TemplatePath."/include/header",$data);
        $this->load->view("delivery/backend/profile");
        $this->load->view(AdminPanel::TemplatePath."/include/footer");

    }

    public function users()
    {

        if(!GroupAccess::isGranted('user',MANAGE_USERS))
            redirect("error?page=permission");

        $params = array(
            "page" => RequestInput::get("page"),
            "id" => RequestInput::get("id"),
            "search" => RequestInput::get("search"),
            'limit' => NO_OF_ITEMS_PER_PAGE,
            "is_super" => TRUE,
            "user_id" => $this->mUserBrowser->getData("id_user")
        );

        $grp = $this->mDeliveryModel->getGrp();
        $params['grp_acc_id'] = $grp->id;
        $params['is_super'] = TRUE;

        $filter = RequestInput::get("filter");

        if($filter=="balance")
            $params['filter-balance'] = TRUE;

        $data['data'] = $this->mUserModel->getUsers($params,function ($params){

            $this->db->where('user.grp_access_id',$params['grp_acc_id']);

            if(isset($params['filter-balance']) && $params['filter-balance']==TRUE){
                $this->db->join('wallet',"wallet.user_id=user.id_user");
                $this->db->where("balance >",0);
            }

        },function ($params){

            $this->db->order_by('user.status ASC, user.id_user DESC');

        });

        $data['title'] = _lang("Delivery users");

        $this->load->view(AdminPanel::TemplatePath."/include/header", $data);
        $this->load->view("delivery/backend/users");
        $this->load->view(AdminPanel::TemplatePath."/include/footer");

    }




}

/* End of file EventDB.php */