<script src="<?= adminAssets("plugins/datepicker/bootstrap-datepicker.js") ?>"></script>
<script src="<?= adminAssets("plugins/select2/select2.full.min.js") ?>"></script>
<script>

    //date setup
    let dateField = $('.datepicker');
    $.fn.datepicker.defaults.format = dateField.attr("data-format");
    dateField.datepicker({
        startDate: '-3d'
    });

    //setup select2
    $('.select2').select2();

    //setup product selector
    $('#linkedProducts').select2({

        ajax: {
            url: '<?=site_url("product/ajax/getProductsAjax")?>',
            dataType: 'json',
            delay: 250,
            type: 'GET',
            data: function (params) {

                console.log(params);

                var query = {
                    search: params.term,
                    store_id: $("#form #selectStore").val(),
                    page: params.page || 1
                };

                console.log("query");
                console.log(query);

                // Query parameters will be ?search=[term]&page=[page]
                return query;
            },
            processResults: function (data, params) {
                // parse the results into the format expected by Select2
                // since we are using custom formatting functions we do not need to
                // alter the remote JSON data, except to indicate that infinite
                // scrolling can be used
                console.log("result");
                console.log(data);

                //results_list = data;

                params.page = params.page || 1;

                return {
                    results: data.results
                }

            },
            cache: true
        }
    });


    //Send data

    $("#form #addBtn").on('click', function () {
        var dataSet0 = {
            "token": "<?=$this->mUserBrowser->setToken("SU74aQ55A")?>",
            "store_id": $("#form #store_id").val(),
            "label": $("#form #label").val(),
            "coupon_value": $("#form #coupon_value").val(),
            "expired_at": $("#form #expired_at").val(),
            "linkedProducts": $("#form #linkedProducts").val(),
        };

        send_data(dataSet0, $(this));

        return false;

    });

    function send_data(dataSet0, selector) {

        $.ajax({
            url: "<?=  site_url("ajax/coupons/add")?>",
            data: dataSet0,
            dataType: 'json',
            type: 'POST',
            beforeSend: function (xhr) {

                NSTemplateUIAnimation.button.loading = selector;

            }, error: function (request, status, error) {
                NSAlertManager.simple_alert.request = "<?=Translate::sprint("Input invalid")?>";
                NSTemplateUIAnimation.button.default = selector;
                console.log(request);
            },
            success: function (data, textStatus, jqXHR) {

                console.log(data);

                if (data.success === 1) {
                    NSTemplateUIAnimation.button.success = selector;
                    document.location.href = "<?=admin_url("coupons/coupons")?>";
                } else if (data.success === 0) {
                    NSTemplateUIAnimation.button.default = selector;
                    var errorMsg = "";
                    for (var key in data.errors) {
                        errorMsg = errorMsg + data.errors[key] + "<br/>";
                    }
                    if (errorMsg !== "") {
                        NSAlertManager.simple_alert.request = errorMsg;
                    }
                }
            }
        });

    }




</script>

