
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <!-- Message Error -->
            <div class="col-sm-12">
                <?php $this->load->view(AdminPanel::TemplatePath."/include/messages"); ?>
            </div>
        </div>

        <div class="row">
            <div class="col-xs-12">
                <div class="box box-solid">
                    <div class="box-header">
                        <div class="box-title" style="width : 100%;">
                            <div class="row">
                                <div class="pull-left col-md-8">
                                    <b><?= Translate::sprint("Coupons") ?></b>
                                </div>

                                <div class="pull-right col-md-4">
                                    <a href="<?=admin_url("coupons/add")?>">
                                        <button type="button" data-toggle="tooltip" title="" class="btn btn-primary btn-sm pull-right"><span class="glyphicon glyphicon-plus"></span></button>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.box-header -->
                    <div class="box-body table-responsive couponsList">
                        <table id="example2" class="table table-bordered table-hover">
                            <thead>
                            <tr>

                                <th><?= Translate::sprint("Label") ?></th>
                                <th><?= Translate::sprint("Linked Products") ?></th>
                                <th><?= Translate::sprint("Code") ?></th>
                                <th><?= Translate::sprint("Value") ?></th>
                                <th><?= Translate::sprint("Expired at") ?></th>
                                <th><?= Translate::sprint("Created at") ?></th>
                                <th>

                                </th>
                            </tr>
                            </thead>
                            <tbody>


                            <?php if (count($result['result']) > 0): ?>
                                <?php foreach ($result['result'] as $coupon): ?>
                                    <tr>
                                        <td>
                                            <?=$coupon['label']?>
                                        </td>
                                        <td>
                                            <p>(<?=count($coupon['products'])?>) <?=_lang("Selected products")?></p>
                                            <ul>
                                                <?php foreach ($coupon['products'] as $pr): ?>
                                                    <li><a target="_blank" href="<?=admin_url("product/edit?id=".$pr['id'])?>"><?=$pr['label']?></a></li>
                                                <?php endforeach; ?>
                                            </ul>
                                        </td>
                                        <td>
                                           <input class="codeCouponField" type="text" value="<?=$coupon['code']?>" />
                                        </td>
                                        <td>
                                            <span class="badge bg-red"><?=$coupon['coupon_value']?>%</span>
                                        </td>

                                        <td>
                                            <?=date("d M Y H:i",strtotime($coupon['expired_at']))?>
                                        </td>
                                        <td>
                                            <?=date("d M Y H:i",strtotime($coupon['created_at']))?>
                                        </td>
                                        <td align="center">

                                            <a href="#"
                                               data-update-status
                                               data-id="<?=$coupon['id']?>"
                                               class=" btn btn-default"
                                               title="<?= Translate::sprint("Update") ?>">
                                                <span class="fa fa-pencil"></span>
                                            </a>

                                            &nbsp;&nbsp;
                                            <a href="#"
                                               data-update-status
                                               data-id="<?=$coupon['id']?>"
                                               class=" btn btn-default Remove"
                                               title="<?= Translate::sprint("Remove") ?>">
                                                <span class="fa fa-trash"></span>
                                            </a>

                                        </td>
                                    </tr>
                                <?php endforeach; ?>

                            <?php else: ?>
                                <tr>
                                    <td colspan="7" align="center"><?= Translate::sprint("No result") ?></td>
                                </tr>
                            <?php endif; ?>


                            </tbody>
                        </table>

                        <div class="row">
                            <div class="col-sm-12 pull-right">
                                <div class="dataTables_paginate paging_simple_numbers" id="example2_paginate">

                                    <?php

                                    echo $result['pagination']->links(array(
                                        "id" => intval(RequestInput::get("id"))
                                    ), admin_url("coupons/coupons"));

                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <!-- /.box-body -->
                </div>
                <!-- /.box -->
            </div>


            <!-- /.col -->
        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->
</div>
<!-- /.content-wrapper -->


<?php


$data0 = array();
$html = $this->load->view('coupons/backend/scripts/list-script', $data0, TRUE);
AdminTemplateManager::addHtml($html);


?>


