<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->

    <!-- Main content -->
    <section class="content">
        <div class="row">
            <!-- Message Error -->
            <div class="col-sm-12">
                <?php $this->load->view(AdminPanel::TemplatePath."/include/messages"); ?>
            </div>

        </div>

        <div class="row" id="form">
            <div class="col-md-12">
                <div class="nav-tabs-custom">
                    <ul class="nav nav-tabs">

                        <li class="active">
                            <a href="#coupon_detail" class="title uppercase" data-toggle="tab"
                               aria-expanded="false"><?= Translate::sprint("Coupon Detail") ?></a></li>


                    </ul>
                    <div class="tab-content">
                        <div class="tab-pane active" id="offer_products">
                            <div class="box-body">
                                <div class="row">
                                    <div class="col-sm-6">
                                        <div class="box box-solid">
                                            <div class="box-header">
                                                <div class="box-title">
                                                    <b><?= Translate::sprint("The coupons will be applied on all products mentioned below") ?></b>
                                                </div>
                                            </div>
                                            <div class="box-body">

                                                <div class="form-group">
                                                    <label><?= Translate::sprint("Select Store") ?> <sup class="text-red">*</sup></label>
                                                    <select id="store_id" class="form-control select2 selectStore"
                                                            style="width: 100%;">
                                                        <option selected="selected" value="0">
                                                            <?= Translate::sprint("Select store", "") ?></option>
                                                        <?php

                                                        if (isset($myStores[Tags::RESULT])) {
                                                            foreach ($myStores[Tags::RESULT] as $st) {
                                                                echo '<option adr="' . $st['address'] . '" 
                                            lat="' . $st['latitude'] . '" lng="' . $st['longitude'] . '" 
                                            value="' . $st['id_store'] . '">' . $st['name'] . '</option>';
                                                            }
                                                        }

                                                        ?>
                                                    </select>
                                                </div>

                                                <div class="form-group">
                                                    <label><?= Translate::sprint("Label", "") ?> <sup class="text-red">*</sup></label>
                                                    <input type="text" class="form-control" name="label" id="label"
                                                           placeholder="Ex: black friday">
                                                </div>


                                                <div class="form-group">
                                                    <label><?= Translate::sprint("Discount Value") ?> (%) <sup class="text-red">*</sup></label>
                                                    <input type="number" class="form-control" name="coupon_value" id="coupon_value"
                                                           placeholder="Ex: 10, 20, 30...">
                                                </div>

                                                <div class="form-group">
                                                    <label><?= Translate::sprint("Expiration date") ?> <sup class="text-red">*</sup></label>
                                                    <input type="text" class="form-control datepicker" name="expired_at" id="expired_at"
                                                           placeholder="YYYY-mm-dd 00:00" data-format="yyyy-mm-dd 00:00">
                                                </div>


                                                <div class="form-group">
                                                    <label><?= _lang("Select one or many products") ?> <sup class="text-red">*</sup></label>
                                                    <select type="text" class="form-control select2"
                                                            multiple="multiple" id="linkedProducts"
                                                            placeholder="<?= _lang("Write product name...") ?>">

                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="box-footer">
                                <?php

                                $usr_id = $this->mUserBrowser->getData('id_user');
                                $nbr_coupons = UserSettingSubscribe::getUDBSetting($usr_id, KS_NBR_COUPONS_MONTHLY);

                                ?>

                                <?php if ($nbr_coupons > 0 or $nbr_coupons == -1): ?>
                                    <button type="button" id="addBtn" class="btn  btn-primary"><span
                                            class="glyphicon glyphicon-check"></span>
                                        <?= Translate::sprint("Add") ?> </button>
                                <?php else: ?>
                                    <button type="button" id="addBtn" class="btn btn-primary addBtn" disabled><span
                                            class="glyphicon glyphicon-check"></span>
                                        <?= Translate::sprint("Add") ?> </button>
                                    &nbsp;&nbsp;
                                    <span class="text-red font-size12px"><i class="mdi mdi-information-outline"></i>&nbsp;<?= Translate::sprint("EXCEEDED_MAX_NBR_COUPONS") . $nbr_coupons ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <!-- /.row -->
    </section>
    <!-- /.content -->
</div>
<?php


$data0 = array();
$html = $this->load->view('coupons/backend/scripts/add-script', $data0, TRUE);
AdminTemplateManager::addHtml($html);


?>
