<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Coupons extends MAIN_Controller implements AdminModuleLoader
{

    public function __construct()
    {
        parent::__construct();
        $this->init('coupons');
    }

    public function onLoad()
    {

        define('ADD_COUPON','add');
        define('EDIT_COUPON','edit');
        define('DELETE_COUPON','delete');
        define('MANAGE_COUPONS','manage_coupons');
        define('KS_NBR_COUPONS_MONTHLY','nbr_coupons_monthly');

        //load model
        $this->load->model("coupons/coupons_model","mCouponsModel");

        //helper
        $this->load->helper("coupons/coupon");
    }


    public function onCommitted($isEnabled)
    {

        if(!$isEnabled)
            return;

        //Setup User Config
        UserSettingSubscribe::set('coupons',array(
            'field_name' => KS_NBR_COUPONS_MONTHLY,
            'field_type' => UserSettingSubscribeTypes::INT,
            'field_default_value' => -1,
            'config_key' => 'NBR_COUPONS_MONTHLY',
            'field_label' => 'Coupons allowed monthly',
            'field_sub_label' => '( -1 Unlimited )',
            'field_comment' => '',
        ));

        AdminTemplateManager::registerMenu(
            'coupons',
            "coupons/menu",
            2.2
        );

        //Setup User Config
        UserSettingSubscribe::set('coupons',array(
            'field_name' => KS_NBR_COUPONS_MONTHLY,
            'field_type' => UserSettingSubscribeTypes::INT,
            'field_default_value' => -1,
            'config_key' => 'NBR_COUPONS_MONTHLY',
            'field_label' => 'Coupons allowed monthly',
            'field_sub_label' => '( -1 Unlimited )',
            'field_comment' => '',
        ));


        ActionsManager::register('order_payment','payment_invoice_generated',function ($invoice){
            $this->mCouponsModel->applyCouponForOrder($invoice);
        });

    }


    private function registerModuleActions(){

        GroupAccess::registerActions("coupons",array(
            ADD_COUPON,
            EDIT_COUPON,
            DELETE_COUPON,
            MANAGE_COUPONS
        ));

    }

    public function onInstall()
    {
        $this->mCouponsModel->createTableDFCoupon();
        return TRUE;
    }

    public function onUpgrade()
    {

        $this->mCouponsModel->createTableDFCoupon();
        $this->registerModuleActions();
        return TRUE;
    }

    public function onEnable()
    {
        $this->registerModuleActions();
        return TRUE;
    }


    public function onAdminLoaded($module)
    {
        /*
         * return bool / function
         */

        return function (){



        };
    }
}