<?php if (!defined('BASEPATH')) exit('No direct script access allowed');


class Admin extends ADMIN_Controller
{

    public function __construct()
    {
        parent::__construct();
        //load models

        $libcssdp = AdminTemplateManager::assets("coupons", "css/style.css");
        AdminTemplateManager::addCssLibs($libcssdp);

    }


    public function update()
    {

        if (!GroupAccess::isGranted('offer',ADD_OFFER))
            redirect("error?page=permission");

        $data["myStores"] = $this->mStoreModel->getMyAllStores(array(
            "user_id"   => $this->mUserBrowser->getData("id_user")
        ));

        $this->load->view(AdminPanel::TemplatePath."/include/header",$data);
        $this->load->view("coupons/backend/add");
        $this->load->view(AdminPanel::TemplatePath."/include/footer");

    }
    public function add()
    {

        if (!GroupAccess::isGranted('coupons',ADD_COUPON))
            redirect("error?page=permission");

        $data["myStores"] = $this->mStoreModel->getMyAllStores(array(
            "user_id"   => $this->mUserBrowser->getData("id_user")
        ));

        $this->load->view(AdminPanel::TemplatePath."/include/header",$data);
        $this->load->view("coupons/backend/add");
        $this->load->view(AdminPanel::TemplatePath."/include/footer");

    }

    public function coupons(){

        if (!GroupAccess::isGranted('coupons'))
            redirect("error?page=permission");

        $params = array(
            "page" => intval(RequestInput::get("page")),
            "user_id" => SessionManager::getData("id_user"),
            "limit" => 30,
        );


        $data['result'] = $this->mCouponsModel->getCoupons($params);

        $this->load->view(AdminPanel::TemplatePath."/include/header", $data);
        $this->load->view("coupons/backend/list");
        $this->load->view(AdminPanel::TemplatePath."/include/footer");


    }

}
