<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Cf_manager extends MAIN_Controller
{

    public function __construct()
    {
        parent::__construct();
        $this->init('cf_manager');
    }

    public function onLoad()
    {
        $this->load->model("cf_manager/cf_manager_model","mCFManager");
        $this->load->helper("cf_manager/func");

        define('MANAGE_CF','manage_custom_fields');

    }

    public function onCommitted($isEnabled)
    {
        if(!$isEnabled)
            return;

        AdminTemplateManager::registerMenuSetting(
            'cf_manager',
            "cf_manager/menu_setting",
            11
        );
    }

    public function onEnable()
    {

        GroupAccess::registerActions("cf_manager",array(
            MANAGE_CF
        ));

        $this->mCFManager->create_default_cf();

        return TRUE;
    }

    public function onUpgrade()
    {
        parent::onUpgrade();

        //update fields in the database
        $this->mCFManager->createCFTable();
        $this->mCFManager->updateFields();

        //update translation
        Translate::updateLanguages("cf_manager");

        return TRUE;
    }


    public function onInstall()
    {
        parent::onInstall(); // TODO: Change the autogenerated stub

        //update fields in the database
        $this->mCFManager->createCFTable();
        $this->mCFManager->updateFields();

        //update translation
        Translate::updateLanguages("cf_manager");

        return TRUE;
    }


}