<?php

$categories = $data[Tags::RESULT];

foreach ($categories as $key => $job) {
    $categories[$key]['name'] = Text::output($categories[$key]['name']);
    $categories[$key]['name'] = Translate::sprint($categories[$key]['name'], $categories[$key]['name']);
}



?>
    <!-- Content Wrapper. Contains page content -->
    <div class="content-wrapper">
        <!-- Main content -->
        <section class="content">
            <div class="row">
                <!-- Message Error -->
                <div class="col-sm-12">
                    <?php $this->load->view(AdminPanel::TemplatePath . "/include/messages"); ?>
                </div>
            </div>

            <div class="row">
                <div class="col-sm-12">
                    <div class="box  box-solid">
                        <div class="box-header">
                            <div class="box-title">
                                <b><?= Translate::sprint("Categories") ?></b>
                            </div>
                            <div class="pull-right">
                                <a href="<?= admin_url("category/add") ?>" class="btn btn-primary btn-sm pull-right">
                                    <span class="glyphicon glyphicon-plus"></span>
                                </a>
                            </div>
                        </div>
                        <!-- /.box-header -->
                        <div class="box-body  table-bordered ">
                            <table class="table table-bordered table-hover">
                                <thead>
                                <tr>
                                    <th width="5%"></th>
                                    <th width="5%"><?= Translate::sprint("Image") ?></th>
                                    <th width="5%"><?= Translate::sprint("Icon") ?></th>
                                    <th></th>
                                </tr>
                                </thead>
                                <tbody class="dd">
                                </tbody>
                            </table>
                            <div class="table-responsive categoriesList" >
                                <?php if (!empty($categories)) : ?>
                                    <?php foreach ($categories as $category) : ?>
                                        <?php $this->load->view('category/backend/html/category-item.php', array("category"=>$category));?>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                            <div class="row">
                                <div class="col-sm-7">
                                    <div class="dataTables_paginate paging_simple_numbers" id="example2_paginate">
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- /.box-body -->
                    </div>
                    <!-- /.box -->


                    <!-- /.box -->
                </div>
            </div>
            <!-- /.row -->
        </section>
        <!-- /.content -->
    </div>
    <!-- /.content-wrapper -->

<?php
$script = $this->load->view('category/backend/html/scripts/list-script', NULL, TRUE);
AdminTemplateManager::addScript($script);
?>