<div class="category-group">
    <table class="table table-responsive">
        <thead>
        <tr class="line re-order line_<?= $category['id_category'] ?>"
            data-id="<?= $category['id_category'] ?>">
            <td  width="5%"><span class="cursor-pointer" style="font-size: 22px"><i
                            class="mdi mdi-menu text-gray"></i></span></td>
            <td width="5%" align="right">
                <img class="icon" src="<?= CategoryManager::getValidImage($category["image"])?>"/>
            </td>
            <td width="5%" align="right">
               <img class="icon" src="<?= CategoryManager::getValidImage($category["icon"])?>"/>
            </td>
            <td>
                 <span><?= Translate::sprint(Text::echo_output($category["name"])) ?></span>
            </td>
            <td align="right">
                <?php if (GroupAccess::isGranted('category', DELETE_CATEGORY)): ?>
                    <a href="#" class="delete"
                       data-id="<?= $category["id_category"] ?>">
                        <button type="button" title="Delete"
                                class="btn btn-sm"><span
                                    class="glyphicon glyphicon-trash"></span>
                        </button>
                    </a>
                <?php endif; ?>
                <?php if (GroupAccess::isGranted('category', EDIT_CATEGORY)): ?>
                    <a href="<?= admin_url("category/edit?id=" . $category["id_category"]) ?>">
                        <button type="button" title="Update"
                                class="btn btn-sm"><span
                                    class="glyphicon glyphicon-edit"></span>
                        </button>
                    </a>
                <?php endif; ?>
            </td>
        </tr>
        </thead>
        <tbody>
        <?php if (!empty($category['sub'])): ?>
            <tr class="sub-categories sub-categories_<?= $category['id_category'] ?>">
                <td></td>
                <td colspan="5">
                    <table class="table sub-table">
                        <?php foreach ($category['sub'] as $subCategory): ?>
                            <tr class="sub-lines re-order sub-line_<?= $subCategory['id_category'] ?>"
                                data-id="<?= $subCategory['id_category'] ?>">
                                <td width="5%"><span class="cursor-pointer" style="font-size: 22px"><i
                                                class="mdi mdi-menu text-gray"></i></span></td>
                                <td width="5%" align="right">
                                    <img class="icon" src="<?= CategoryManager::getValidImage($subCategory["image"])?>"/>
                                </td>
                                <td width="5%" align="right">
                                    <img class="icon" src="<?= CategoryManager::getValidImage($subCategory["icon"])?>"/>
                                </td>
                                <td>
                                    <span><?= Translate::sprint(Text::echo_output($subCategory["name"])) ?></span>
                                </td>
                                <td align="right">
                                    <?php if (GroupAccess::isGranted('category', DELETE_CATEGORY)): ?>
                                        <a href="#" class="delete"
                                           data-id="<?= $subCategory["id_category"] ?>">
                                            <button type="button" title="Delete"
                                                    class="btn btn-sm"><span
                                                        class="glyphicon glyphicon-trash"></span>
                                            </button>
                                        </a>
                                    <?php endif; ?>
                                    <?php if (GroupAccess::isGranted('category', EDIT_CATEGORY)): ?>
                                        <a href="<?= admin_url("category/edit?id=" . $subCategory["id_category"]) ?>">
                                            <button type="button" title="Update"
                                                    class="btn btn-sm"><span
                                                        class="glyphicon glyphicon-edit"></span>
                                            </button>
                                        </a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </table>
                </td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>

