<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Created by DT Team.
 * AppName: NearbyStores
 */

class Category extends MAIN_Controller {

    public function __construct(){
        parent::__construct();
        /////// register module ///////
        $this->init("category");
    }

    public function onLoad()
    {

        define('ADD_CATEGORY','add');
        define('EDIT_CATEGORY','edit');
        define('DELETE_CATEGORY','delete');

        //load model
        $this->load->model("category/category_model","mCategoryModel");
        //load helper
        $this->load->helper("category/category");

    }

    //call it after loading all modules

    public function onCommitted($isEnabled)
    {
        parent::onCommitted($isEnabled); // TODO: Change the autogenerated stub

        if(!$isEnabled)
            return;

        AdminTemplateManager::registerMenuSetting(
            'category',
            "category/menu",
            12
        );


    }

    private function registerModuleActions(){

        GroupAccess::registerActions("category",array(
            ADD_CATEGORY,
            EDIT_CATEGORY,
            DELETE_CATEGORY,
        ));

    }

	public function index()
	{

	}

	public function onEnable()
    {
        $this->registerModuleActions();
    }

    public function onInstall()
    {
        parent::onInstall(); // TODO: Change the autogenerated stub
        $this->mCategoryModel->createMultipleCategories();
        $this->mCategoryModel->updateFields();

        return TRUE;
    }

    public function onUpgrade()
    {
        parent::onUpgrade(); // TODO: Change the autogenerated stub
        $this->mCategoryModel->createMultipleCategories();
        $this->mCategoryModel->updateFields();

        $this->registerModuleActions();

        return TRUE;
    }
}

/* End of file CategoryDB.php */