<?php if (!defined('BASEPATH')) exit('No direct script access allowed');

class Business_manager extends MAIN_Controller implements AdminModuleLoader
{

    public function __construct()
    {
        parent::__construct();
        $this->init('business_manager');

    }


    public function index(){

        $lang = RequestInput::get("lang");
        $uri = RequestInput::get("uri");
        $session = RequestInput::get("session");

        $data['session'] = $session;
        $data['lang'] = $lang;
        $data['uri'] = $uri;

        if(preg_match("#[a-zA-Z]{2}#",$lang)){

            Translate::changeSessionLang($lang);
            redirect("business_manager/index?uri=".$uri."&session=".$session);

        }

        if(SessionManager::isLogged()){

            if($session != SessionManager::getData("username")){

                $def_lang = Translate::getDefaultLangCode();

                $this->mUserBrowser->LogOut();

                redirect("business_manager/index?lang=".$def_lang);

            }else{

                redirect(admin_url("business_manager/".$uri));
            }
        }else{
            $this->login($data);
        }
    }

    private function login($data){

        if(SessionManager::isLogged())
            redirect(admin_url("business_manager/businesses"));

        $data['title'] = _lang("Login");

        if(!Text::checkUsernameValidate($data['session']))
            $data['session'] = "";

        $this->load->view("business_manager/header", $data);
        $this->load->view("business_manager/user/login");
        $this->load->view("business_manager/footer");
    }



    public function error(){

        $data['title'] = _lang("404 Error");
        $this->load->view("business_manager/header", $data);
        $this->load->view("business_manager/error");
        $this->load->view("business_manager/footer");
    }


    public function onLoad()
    {
        parent::onLoad(); // TODO: Change the autogenerated stub

        $this->load->helper("business_manager/business_manager");

    }

    public function onCommitted($isEnabled)
    {

        if(!$isEnabled)
            return;

        //?ifumb=true
        $ifumb = RequestInput::get("ifumb");

        if($ifumb=="true" OR $ifumb==true){
            $business_manager_callback = $this->session->userdata("business_manager_callback");
            if($business_manager_callback !="")
                redirect(admin_url("business_manager/businesses"));
        }
    }

    public function onEnable()
    {

        return TRUE;
    }

    public function onInstall()
    {
        parent::onInstall(); // TODO: Change the autogenerated stub

        return TRUE;
    }


    public function onUpgrade()
    {
        parent::onUpgrade(); // TODO: Change the autogenerated stub

        return TRUE;
    }

    public function onUninstall()
    {
        parent::onUninstall(); // TODO: Change the autogenerated stub

        return TRUE;
    }


    public function checkMobileRequest($token){




        $this->session->set_userdata(array(
            "agent" => "mobile",
            "user_action" => "businessLogin",
            "callback_user_login_redirection" => site_url("webdashboard"),
        ));

        $tokenObject = TokenSetting::get_by_token($token,NULL);

        if($tokenObject != NULL){
            SessionManager::refresh($tokenObject->uid);
            redirect(admin_url());
            return;
        }

        redirect("user/login");

    }

    public function onAdminLoaded($module)
    {
        //include token in the url
        if(!SessionManager::isLogged()){
            return;
        }

        $action = $this->session->userdata('user_action');
        if($action == "businessLogin"){

            $uid = SessionManager::getData("id_user");
            $token = TokenSetting::createToken($uid,"BusinessLogged");

            $this->session->set_userdata(array(
                "user_action" => "",
            ));

            redirect(admin_url("?userToken=".$token));
        }

    }


}