<?php if ( ! defined('BASEPATH')) exit('No direct script access allowed');

/**
 * Created by DT Team.
 * AppName: NearbyStores
 */

class Bookmark extends MAIN_Controller {

    private $module = "bookmark";

    public function __construct(){
        parent::__construct();
        $this->init($this->module);

    }

    public function onLoad()
    {

        $this->load->model('bookmark/bookmark_model','mBookmarkModel');
        $this->load->helper('bookmark/bookmark');

    }

    public function onCommitted($isEnabled)
    {

        if(!$isEnabled)
            return;


        //handle store deleted action
        ActionsManager::register("store","onDelete",function ($args){
            if(isset($args['id'])){
                $this->db->where("module","store");
                $this->db->where("module_id",$args['id']);
                $this->db->delete("bookmarks");
            }
        });

        //handle event deleted action
        ActionsManager::register("event","onDelete",function ($args){
            if(isset($args['id'])){

                $this->db->where("module","event");
                $this->db->where("module_id",$args['id']);
                $this->db->delete("bookmarks");

            }
        });

        //handle offer deleted action
        ActionsManager::register("offer","onDelete",function ($args){
            if(isset($args['id'])){
                $this->db->where("module","offer");
                $this->db->where("module_id",$args['id']);
                $this->db->delete("bookmarks");
            }
        });

        //handle user deleted action
        ActionsManager::register("user","onDelete",function ($args){
            if(isset($args['id'])){
                $this->db->where("user_id",$args['id']);
                $this->db->delete("bookmarks");
            }
        });


        //handle guest deleted action
        ActionsManager::register("guest","onDelete",function ($args){
            if(isset($args['id'])){
                $this->db->where("guest_id",$args['id']);
                $this->db->delete("bookmarks");
            }
        });


    }


    public function cron(){

        $this->mBookmarkModel->clear_removed_cache();

    }

    public function onEnable()
    {
        return parent::onEnable(); // TODO: Change the autogenerated stub
    }

    public function onInstall()
    {
        parent::onInstall(); // TODO: Change the autogenerated stub
        $this->mBookmarkModel->createBookmarksTable();


        return TRUE;
    }

    public function onUpgrade()
    {
        parent::onUpgrade(); // TODO: Change the autogenerated stub
        $this->mBookmarkModel->createBookmarksTable();
        $this->mBookmarkModel->update_fields();

        return TRUE;
    }


}

/* End of file UploaderDB.php */